"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceScreenshotModel = void 0;
const helper_1 = require("../../helper");
const generator_1 = require("@signageos/lib/dist/Hash/generator");
const getKey = (identityHash) => `deviceScreenshot.${identityHash}`;
const createDeviceScreenshotModel = (connection) => ({
    create: (deviceIdentityHash, uri, takenAt) => __awaiter(void 0, void 0, void 0, function* () {
        const newRow = {
            id: (0, generator_1.generateUniqueHash)(),
            uri,
            takenAt,
            deviceIdentityHash,
        };
        yield (0, helper_1.updateOne)(connection, getKey(deviceIdentityHash), newRow);
    }),
    observeLatestByDevice: ({ identityHash }) => __awaiter(void 0, void 0, void 0, function* () {
        return (0, helper_1.observe)(connection, getKey(identityHash));
    }),
    deleteTakenUntil(_takenUntil) {
        return __awaiter(this, void 0, void 0, function* () {
            // irrelevant. Too old data to be observed
        });
    },
});
exports.createDeviceScreenshotModel = createDeviceScreenshotModel;
//# sourceMappingURL=deviceScreenshotModel.js.map