"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceProvisioningRecipeModel = void 0;
const helper_1 = require("../../helper");
const helpers_1 = require("@signageos/lib/dist/Observable/helpers");
const model_1 = require("../../Lib/Model/model");
const waitUntil_1 = require("@signageos/lib/dist/DateTime/waitUntil");
const recipeUidKeyPrefix = 'deviceProvisioningRecipe.uid';
function getRecipeUidKey(uid) {
    return `${recipeUidKeyPrefix}.${uid}`;
}
const recipeUidRemoveKeyPrefix = 'deviceProvisioningRecipe.remove.uid';
function getRecipeRemoveUidKey(uid) {
    return `${recipeUidRemoveKeyPrefix}.${uid}`;
}
const recipesListKey = 'deviceProvisioningRecipe.list';
const createDeviceProvisioningRecipeModel = (conn, sourceModel) => {
    function observeRecipe(recipeKey, recipeRemoveKey) {
        const observableRemove = (0, helper_1.observe)(conn, recipeRemoveKey).map((changes) => {
            var _a;
            return {
                old_val: { uid: (_a = changes.old_val) === null || _a === void 0 ? void 0 : _a.uid },
                new_val: null,
                clusterTime: changes.clusterTime,
            };
        });
        const observable = (0, helper_1.observe)(conn, recipeKey);
        return (0, helpers_1.mergeObservables)(observableRemove, (0, helpers_1.asyncMap)(observable, (changes) => __awaiter(this, void 0, void 0, function* () {
            var _a;
            const recipe = changes.new_val !== null
                ? yield (0, waitUntil_1.waitUntilNotNull)(() => __awaiter(this, void 0, void 0, function* () {
                    var _b;
                    return yield sourceModel.fetchByUid((_b = changes.new_val) === null || _b === void 0 ? void 0 : _b.uid);
                }))
                : null;
            return {
                old_val: { uid: (_a = changes.new_val) === null || _a === void 0 ? void 0 : _a.uid },
                new_val: recipe,
                clusterTime: changes.clusterTime,
            };
        })));
    }
    function keysBuilder(uid) {
        return [recipesListKey, getRecipeUidKey(uid)];
    }
    function removedKeysBuilder(uid) {
        return [recipesListKey, getRecipeRemoveUidKey(uid)];
    }
    function updateRecipePartial(recipePartial) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, helper_1.updateOne)(conn, getRecipeUidKey(recipePartial.uid), recipePartial);
            yield (0, helper_1.updateOne)(conn, recipesListKey, recipePartial);
        });
    }
    function deleteRecipePartial(recipePartial) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, helper_1.updateOnDelete)(conn, getRecipeRemoveUidKey(recipePartial.uid), recipePartial);
            yield (0, helper_1.updateOnDelete)(conn, recipesListKey, recipePartial);
        });
    }
    return Object.assign(Object.assign({}, (0, model_1.createModel)({
        keysBuilder,
        removedKeysBuilder,
        conn,
    })), { create(recipeRow) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateRecipePartial({ uid: recipeRow.uid });
            });
        },
        delete(uid) {
            return __awaiter(this, void 0, void 0, function* () {
                yield deleteRecipePartial({ uid });
            });
        },
        deleteMany(uids) {
            return __awaiter(this, void 0, void 0, function* () {
                for (const uid of uids) {
                    yield deleteRecipePartial({ uid });
                }
            });
        },
        observeByUid(uid) {
            return __awaiter(this, void 0, void 0, function* () {
                return observeRecipe(getRecipeUidKey(uid), getRecipeRemoveUidKey(uid));
            });
        },
        observeListByFilters(filters, paginationAndSorting) {
            return __awaiter(this, void 0, void 0, function* () {
                const observable = (0, helper_1.observe)(conn, recipesListKey);
                return (0, helpers_1.asyncMap)(observable, (_changes) => __awaiter(this, void 0, void 0, function* () {
                    return yield sourceModel.fetchListByFilters(filters, paginationAndSorting);
                }));
            });
        } });
};
exports.createDeviceProvisioningRecipeModel = createDeviceProvisioningRecipeModel;
//# sourceMappingURL=deviceProvisioningRecipeModel.js.map