"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDevicePolicyStatusModel = void 0;
const helper_1 = require("../../helper");
const devicePolicyStatusDeviceIdentityHashPrefix = 'devicePolicyStatus.deviceIdentityHash';
function getDevicePolicyStatusDeviceIdentityHashKey(deviceIdentityHash) {
    return `${devicePolicyStatusDeviceIdentityHashPrefix}.${deviceIdentityHash}`;
}
const devicePolicyStatusPolicyUidPrefix = 'devicePolicyStatus.policyUid';
function getDevicePolicyStatusPolicyUidKey(policyUid) {
    return `${devicePolicyStatusPolicyUidPrefix}.${policyUid}`;
}
const createDevicePolicyStatusModel = (conn) => ({
    observeByDevice({ identityHash }) {
        return __awaiter(this, void 0, void 0, function* () {
            const observable = (0, helper_1.observe)(conn, getDevicePolicyStatusDeviceIdentityHashKey(identityHash));
            return observable;
        });
    },
    observeByPolicy({ uid }) {
        return __awaiter(this, void 0, void 0, function* () {
            const observable = (0, helper_1.observe)(conn, getDevicePolicyStatusPolicyUidKey(uid));
            return observable;
        });
    },
    upsert({ identityHash }, policy, itemType, success, updatedAt) {
        return __awaiter(this, void 0, void 0, function* () {
            const devicePolicyStatus = {
                deviceIdentityHash: identityHash,
                policyUid: policy.uid,
                itemType,
                success,
                updatedAt,
            };
            yield (0, helper_1.updateOne)(conn, getDevicePolicyStatusDeviceIdentityHashKey(identityHash), devicePolicyStatus);
            yield (0, helper_1.updateOne)(conn, getDevicePolicyStatusPolicyUidKey(policy.uid), devicePolicyStatus);
        });
    },
    remove(devicePolicyStatusRow) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, helper_1.updateOnDelete)(conn, getDevicePolicyStatusDeviceIdentityHashKey(devicePolicyStatusRow.deviceIdentityHash), devicePolicyStatusRow);
            yield (0, helper_1.updateOnDelete)(conn, getDevicePolicyStatusPolicyUidKey(devicePolicyStatusRow.policyUid), devicePolicyStatusRow);
        });
    },
    removeByDeviceAndPolicy({ identityHash }, policy) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, helper_1.updateOnDelete)(conn, getDevicePolicyStatusDeviceIdentityHashKey(identityHash), {
                deviceIdentityHash: identityHash,
                policyUid: policy.uid,
            });
        });
    },
    removeByPolicyAndItemType(policy, itemType) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, helper_1.updateOnDelete)(conn, getDevicePolicyStatusPolicyUidKey(policy.uid), {
                policyUid: policy.uid,
                itemType,
            });
        });
    },
});
exports.createDevicePolicyStatusModel = createDevicePolicyStatusModel;
//# sourceMappingURL=devicePolicyStatusModel.js.map