"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceMonitoringLogModel = void 0;
const helper_1 = require("../../helper");
const deviceMonitoringLog_utils_1 = require("./deviceMonitoringLog.utils");
const deviceIdentityHashAndMonitoringTypePrefix = 'deviceMonitoringLog.identityHash-monitoringType';
function getDeviceIdentityHashAndMonitoringTypeKey(identityHash, monitoringType) {
    return `${deviceIdentityHashAndMonitoringTypePrefix}.${identityHash}-${monitoringType}.cache`;
}
const createDeviceMonitoringLogModel = (conn) => ({
    create(id, type, device, createdAt, data) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, helper_1.createOne)(conn, getDeviceIdentityHashAndMonitoringTypeKey(device.identityHash, type), {
                id,
                deviceIdentityHash: device.identityHash,
                organizationUid: (_a = device.organizationUid) !== null && _a !== void 0 ? _a : undefined,
                type,
                createdAt,
                data,
            });
        });
    },
    createMany(_monitoringLogs) {
        return __awaiter(this, void 0, void 0, function* () {
            throw new Error(`Not implemented method.`);
        });
    },
    invalidate(type, device) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, helper_1.deleteOne)(conn, getDeviceIdentityHashAndMonitoringTypeKey(device.identityHash, type));
        });
    },
    fetchLatestByDeviceAndType(device, type) {
        return __awaiter(this, void 0, void 0, function* () {
            return (0, helper_1.getOne)(conn, getDeviceIdentityHashAndMonitoringTypeKey(device.identityHash, type));
        });
    },
    fetchLatestByIdentityHashAndType(identityHash, type) {
        return __awaiter(this, void 0, void 0, function* () {
            return (0, helper_1.getOne)(conn, getDeviceIdentityHashAndMonitoringTypeKey(identityHash, type));
        });
    },
    fetchLatestByDevicesAndType(deviceIdentityHashes, type) {
        return __awaiter(this, void 0, void 0, function* () {
            const list = [];
            for (const identityHash of deviceIdentityHashes) {
                const monitoringLog = yield this.fetchLatestByDeviceAndType({ identityHash }, type);
                if (monitoringLog) {
                    list.push(monitoringLog);
                }
            }
            return list;
        });
    },
    fetchLatestListByDevices({ devices, }) {
        return __awaiter(this, void 0, void 0, function* () {
            const monitoringLogs = yield (0, deviceMonitoringLog_utils_1.getMonitoringLogsByDates)({
                identityHashes: devices.map((device) => device.identityHash),
                fetchLatestByIdentityHashAndType: this.fetchLatestByIdentityHashAndType,
            });
            return monitoringLogs;
        });
    },
});
exports.createDeviceMonitoringLogModel = createDeviceMonitoringLogModel;
//# sourceMappingURL=deviceMonitoringLogModel.js.map