"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceHourlyConnectedStatusModel = void 0;
const moment = require("moment");
const generator_1 = require("@signageos/lib/dist/Hash/generator");
const helper_1 = require("../../helper");
function getKey(identityHash) {
    return `deviceHourlyConnectedStatusModel.${identityHash}`;
}
const createDeviceHourlyConnectedStatusModel = (conn) => ({
    create(device, createdAt, from, to, time) {
        return __awaiter(this, void 0, void 0, function* () {
            const newRow = {
                uid: (0, generator_1.generateUniqueHash)(),
                deviceIdentityHash: device.identityHash,
                createdAt,
                from,
                to,
                time,
            };
            yield (0, helper_1.updateOne)(conn, getKey(device.identityHash), newRow);
        });
    },
    observeLatestConnectedStatusByDevice(device, after) {
        return __awaiter(this, void 0, void 0, function* () {
            const observable = (0, helper_1.observe)(conn, getKey(device.identityHash));
            const filteredObservable = observable.filter((row) => !!row.new_val && moment(row.new_val.from).isSameOrAfter(after));
            return filteredObservable;
        });
    },
    deleteFromBefore(_fromBefore) {
        return __awaiter(this, void 0, void 0, function* () {
            // irrelevant. Too old data to be observed
        });
    },
});
exports.createDeviceHourlyConnectedStatusModel = createDeviceHourlyConnectedStatusModel;
//# sourceMappingURL=deviceHourlyConnectedStatusModel.js.map