"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceInfoModel = void 0;
const helpers_1 = require("@signageos/lib/dist/Observable/helpers");
const helper_1 = require("../../helper");
function getKey(identityHash) {
    return `deviceInfo.${identityHash}`;
}
const createDeviceInfoModel = (conn) => ({
    observeListByIdentityHashes(identityHashes) {
        return __awaiter(this, void 0, void 0, function* () {
            return (0, helpers_1.mergeObservables)(...identityHashes.map((identityHash) => (0, helper_1.observe)(conn, getKey(identityHash))));
        });
    },
    create(identityHash) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, helper_1.updatePartialOne)(conn, getKey(identityHash), {
                identityHash,
            });
        });
    },
    updateNetworkInterface(deviceInfoRow, networkSettings) {
        return __awaiter(this, void 0, void 0, function* () {
            const networkInterfaceSettings = {
                macAddress: networkSettings.macAddress,
            };
            if (networkSettings.ipAddress !== undefined) {
                networkInterfaceSettings.ipAddress = networkSettings.ipAddress;
            }
            if (networkSettings.netmask !== undefined) {
                networkInterfaceSettings.netmask = networkSettings.netmask;
            }
            if (networkSettings.gateway !== undefined) {
                networkInterfaceSettings.gateway = networkSettings.gateway;
            }
            if (networkSettings.domainNameServers !== undefined) {
                networkInterfaceSettings.domainNameServers = networkSettings.domainNameServers;
            }
            if (networkSettings.interfaceName !== undefined) {
                networkInterfaceSettings.interfaceName = networkSettings.interfaceName;
            }
            if (networkSettings.ssid !== undefined) {
                networkInterfaceSettings.ssid = networkSettings.ssid;
            }
            if (networkSettings.signalStrength !== undefined) {
                networkInterfaceSettings.signalStrength = networkSettings.signalStrength;
            }
            yield (0, helper_1.updatePartialOne)(conn, getKey(deviceInfoRow.identityHash), {
                identityHash: deviceInfoRow.identityHash,
                networkInterfaces: {
                    [networkSettings.networkInterface]: networkInterfaceSettings,
                },
            });
        });
    },
    updateSpecs(deviceInfoRow, specs) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, helper_1.updatePartialOne)(conn, getKey(deviceInfoRow.identityHash), {
                identityHash: deviceInfoRow.identityHash,
                specs,
            });
        });
    },
    updateBatteryStatus(deviceInfoRow, batteryStatus) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, helper_1.updatePartialOne)(conn, getKey(deviceInfoRow.identityHash), {
                identityHash: deviceInfoRow.identityHash,
                batteryStatus,
            });
        });
    },
    updateStorageStatus(deviceInfoRow, storageStatus) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, helper_1.updatePartialOne)(conn, getKey(deviceInfoRow.identityHash), {
                identityHash: deviceInfoRow.identityHash,
                storageStatus,
            });
        });
    },
    updateCurrentTime(deviceInfoRow, currentTime, isIncorrect) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, helper_1.updatePartialOne)(conn, getKey(deviceInfoRow.identityHash), Object.assign({ identityHash: deviceInfoRow.identityHash, currentTime }, (isIncorrect !== undefined && { incorrectTime: isIncorrect })));
        });
    },
    updateSupportedResolutions(deviceInfoRow, supportedResolutions) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, helper_1.updatePartialOne)(conn, getKey(deviceInfoRow.identityHash), {
                identityHash: deviceInfoRow.identityHash,
                supportedResolutions,
            });
        });
    },
    updatePolicyItemTypes(deviceInfoRow, policyItemTypes) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, helper_1.updatePartialOne)(conn, getKey(deviceInfoRow.identityHash), {
                identityHash: deviceInfoRow.identityHash,
                policyItemTypes,
            });
        });
    },
    updateProxy(deviceInfoRow, proxy) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, helper_1.updatePartialOne)(conn, getKey(deviceInfoRow.identityHash), {
                identityHash: deviceInfoRow.identityHash,
                proxy,
            });
        });
    },
    updateManagementPackageVersion(deviceIdentification, managementPackageVersion) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, helper_1.updatePartialOne)(conn, getKey(deviceIdentification.identityHash), {
                identityHash: deviceIdentification.identityHash,
                managementPackageVersion,
            });
        });
    },
    updateFrontPackageVersion(deviceIdentification, frontPackageVersion) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, helper_1.updatePartialOne)(conn, getKey(deviceIdentification.identityHash), {
                identityHash: deviceIdentification.identityHash,
                frontPackageVersion,
            });
        });
    },
});
exports.createDeviceInfoModel = createDeviceInfoModel;
//# sourceMappingURL=deviceInfoModel.js.map