"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceConnectionsWatcher = void 0;
const deviceConnectionModel_1 = require("./deviceConnectionModel");
const helper_1 = require("../../helper");
const createDeviceConnectionsWatcher = (conn, ttlSeconds = deviceConnectionModel_1.TTL_SECONDS) => {
    const model = (0, deviceConnectionModel_1.createDeviceConnectionModel)(conn, ttlSeconds);
    let checker = undefined;
    /** All redis connections key=connectionUid, value=originalRedisKey which is prolonged because connection is alive */
    const currentMap = new Map();
    function prolongOne(connectionUid, connKey) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                yield (0, helper_1.setExpiration)(conn, connKey, ttlSeconds);
            }
            catch (error) {
                console.error('Could not prolong connection redis key TTL', connectionUid, connKey, error);
            }
        });
    }
    const prolongAll = () => {
        for (const [connectionUid, connKey] of currentMap.entries()) {
            // run in background and don't wait for response
            prolongOne(connectionUid, connKey);
        }
    };
    return {
        start(intervalSeconds) {
            if (checker) {
                throw new Error('Watcher has been already started.');
            }
            const interval = intervalSeconds !== null && intervalSeconds !== void 0 ? intervalSeconds : Math.round(deviceConnectionModel_1.TTL_SECONDS / 2);
            checker = setInterval(prolongAll, interval * 1000);
        },
        stop() {
            if (checker) {
                clearInterval(checker);
                checker = undefined;
            }
        },
        add(connectionUid, deviceUid, serverInstanceUid = '', organizationUid, socketName) {
            return __awaiter(this, void 0, void 0, function* () {
                const connKey = (0, deviceConnectionModel_1.getConnectionKey)(connectionUid);
                const device = { uid: deviceUid, organizationUid };
                yield model.create(connectionUid, device, serverInstanceUid, new Date(), socketName);
                currentMap.set(connectionUid, connKey);
            });
        },
        remove(connectionUid, deviceUid, organizationUid, socketName) {
            return __awaiter(this, void 0, void 0, function* () {
                const connection = { uid: connectionUid, deviceUid, organizationUid, socketName };
                yield model.remove(connection);
                currentMap.delete(connectionUid);
            });
        },
    };
};
exports.createDeviceConnectionsWatcher = createDeviceConnectionsWatcher;
//# sourceMappingURL=deviceConnectionsWatcher.js.map