"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createBulkOperationModel = void 0;
const helpers_1 = require("@signageos/lib/dist/Observable/helpers");
const helper_1 = require("../helper");
const waitUntil_1 = require("@signageos/lib/dist/DateTime/waitUntil");
const bulkOperationUidKeyPrefix = 'bulkOperation.uid';
function getBulkOperationUidKey(uid) {
    return `${bulkOperationUidKeyPrefix}.${uid}`;
}
function updateBulkOperation(conn, bulkOperationId) {
    return __awaiter(this, void 0, void 0, function* () {
        yield (0, helper_1.updatePartialOne)(conn, getBulkOperationUidKey(bulkOperationId), {
            uid: bulkOperationId,
        });
    });
}
const createBulkOperationModel = (conn, sourceModel) => {
    function observeBulkOperation(bulkOperationUidKey) {
        const observable = (0, helper_1.observe)(conn, bulkOperationUidKey);
        return (0, helpers_1.asyncMap)(observable, (changes) => __awaiter(this, void 0, void 0, function* () {
            const bulkOperation = yield (0, waitUntil_1.waitUntilNotNull)(() => __awaiter(this, void 0, void 0, function* () {
                return yield sourceModel.fetchByUid(changes.new_partial_val.uid);
            }));
            return {
                old_val: { uid: changes.new_partial_val.uid },
                new_val: bulkOperation,
                clusterTime: changes.clusterTime,
            };
        }));
    }
    return {
        observeByUid: (bulkOperationUid) => __awaiter(void 0, void 0, void 0, function* () {
            return observeBulkOperation(getBulkOperationUidKey(bulkOperationUid));
        }),
        updateFailedDevice: (bulkOperationId, _deviceUid, _decrementInProgress = true) => __awaiter(void 0, void 0, void 0, function* () {
            yield updateBulkOperation(conn, bulkOperationId);
        }),
        updateSuccessfulDevice: (bulkOperationId, _deviceUid, _decrementInProgress = true) => __awaiter(void 0, void 0, void 0, function* () {
            yield updateBulkOperation(conn, bulkOperationId);
        }),
        updateSkippedDevice: (bulkOperationId, _deviceUid, _decrementInProgress = true) => __awaiter(void 0, void 0, void 0, function* () {
            yield updateBulkOperation(conn, bulkOperationId);
        }),
        updateInProgressDevice: (bulkOperationId, _deviceUid, _updateValue) => __awaiter(void 0, void 0, void 0, function* () {
            yield updateBulkOperation(conn, bulkOperationId);
        }),
        updateIsRunning: (bulkOperationId, _updateValue) => __awaiter(void 0, void 0, void 0, function* () {
            yield updateBulkOperation(conn, bulkOperationId);
        }),
        create: (_bulkOperation) => __awaiter(void 0, void 0, void 0, function* () {
            // We don't want to observe for this change now
        }),
        updateDateRecord: (bulkOperationId, _updateObject) => __awaiter(void 0, void 0, void 0, function* () {
            yield updateBulkOperation(conn, bulkOperationId);
        }),
        setCurrentStatusToWaiting: (bulkOperationId) => __awaiter(void 0, void 0, void 0, function* () {
            yield updateBulkOperation(conn, bulkOperationId);
        }),
        updateRollingUpdate: (_bulkOperationId, _update) => __awaiter(void 0, void 0, void 0, function* () {
            // We don't want to observe for this change now
        }),
        addDeviceToDraft: (_bulkOperationUid, _deviceIdentityHashes) => __awaiter(void 0, void 0, void 0, function* () {
            // We don't want to observe for this change now
        }),
        finishDraft: (_bulkOperationUid) => __awaiter(void 0, void 0, void 0, function* () {
            // We don't want to observe for this change now
        }),
        addDeviceUids: (_bulkOperationUid, _deviceUids) => __awaiter(void 0, void 0, void 0, function* () {
            // We don't want to observe for this change now
        }),
    };
};
exports.createBulkOperationModel = createBulkOperationModel;
//# sourceMappingURL=bulkOperationModel.js.map