"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createApplicationVersionModel = void 0;
const helper_1 = require("../../helper");
const helpers_1 = require("@signageos/lib/dist/Observable/helpers");
const waitUntil_1 = require("@signageos/lib/dist/DateTime/waitUntil");
const applicationVersionAllKey = 'applicationVersion.all';
const createApplicationVersionModel = (conn, sourceModel, applicationModel) => {
    function updateApplicationVersionPartial(applicationVersionPartial) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, helper_1.updatePartialOne)(conn, applicationVersionAllKey, applicationVersionPartial);
        });
    }
    function observeApplicationVersion(applicataionVersionKey) {
        const observable = (0, helper_1.observe)(conn, applicataionVersionKey);
        return (0, helpers_1.asyncMap)(observable, (changes) => __awaiter(this, void 0, void 0, function* () {
            const application = yield (0, waitUntil_1.waitUntilNotNull)(() => __awaiter(this, void 0, void 0, function* () {
                return yield applicationModel.fetchByType(changes.new_partial_val.application);
            }));
            if (!application) {
                throw new Error(`Application doesn't exist`);
            }
            const applicationVersion = yield (0, waitUntil_1.waitUntilNotNull)(() => __awaiter(this, void 0, void 0, function* () {
                return yield sourceModel.fetchByApplicationAndVersion(application, changes.new_partial_val.version);
            }));
            if (!applicationVersion) {
                throw new Error(`Application version doesn't exist`);
            }
            return {
                old_val: applicationVersion,
                new_val: applicationVersion,
                clusterTime: changes.clusterTime,
            };
        }));
    }
    return {
        create(application, _frontDisplayVersion, version, _supportedFirmwareTypes, _createdAt) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateApplicationVersionPartial({
                    application: application.type,
                    version,
                });
            });
        },
        markAsPublished(applicationVersionRow, _publishedSince) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateApplicationVersionPartial({
                    application: applicationVersionRow.application,
                    version: applicationVersionRow.version,
                });
            });
        },
        markAsNotPublished(applicationVersionRow) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateApplicationVersionPartial({
                    application: applicationVersionRow.application,
                    version: applicationVersionRow.version,
                });
            });
        },
        markAsDeprecated(applicationVersionRow, _deprecatedSince) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateApplicationVersionPartial({
                    application: applicationVersionRow.application,
                    version: applicationVersionRow.version,
                });
            });
        },
        markAsNotDeprecated(applicationVersionRow) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateApplicationVersionPartial({
                    application: applicationVersionRow.application,
                    version: applicationVersionRow.version,
                });
            });
        },
        updateDescription(applicationVersionRow, _description) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateApplicationVersionPartial({
                    application: applicationVersionRow.application,
                    version: applicationVersionRow.version,
                });
            });
        },
        observeAll() {
            return __awaiter(this, void 0, void 0, function* () {
                return observeApplicationVersion(applicationVersionAllKey);
            });
        },
        setTestSuite(applicationVersionRow, _suiteGroup, _tests) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateApplicationVersionPartial({
                    application: applicationVersionRow.application,
                    version: applicationVersionRow.version,
                });
            });
        },
        setTestSuitePassed(applicationVersionRow, _suiteGroup, _passedAt) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateApplicationVersionPartial({
                    application: applicationVersionRow.application,
                    version: applicationVersionRow.version,
                });
            });
        },
        setTestSuiteFailed(applicationVersionRow, _suiteGroup, _failed) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateApplicationVersionPartial({
                    application: applicationVersionRow.application,
                    version: applicationVersionRow.version,
                });
            });
        },
        addTestPassed(applicationVersionRow, _suiteGroup, _identification) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateApplicationVersionPartial({
                    application: applicationVersionRow.application,
                    version: applicationVersionRow.version,
                });
            });
        },
        addTestFailed(applicationVersionRow, _suiteGroup, _identification) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateApplicationVersionPartial({
                    application: applicationVersionRow.application,
                    version: applicationVersionRow.version,
                });
            });
        },
    };
};
exports.createApplicationVersionModel = createApplicationVersionModel;
//# sourceMappingURL=applicationVersionModel.js.map