"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAlertRuleModel = void 0;
const helper_1 = require("../helper");
const helpers_1 = require("@signageos/lib/dist/Observable/helpers");
const waitUntil_1 = require("@signageos/lib/dist/DateTime/waitUntil");
const alertRuleUidKeyPrefix = 'alertRule.alertRuleUid';
function getAlertRuleUidKey(uid) {
    return `${alertRuleUidKeyPrefix}.${uid}`;
}
const alertRuleCompanyUidKeyPrefix = 'alertRule.companyUid';
function getAlertRuleCompanyUidKey(companyUid) {
    return `${alertRuleCompanyUidKeyPrefix}.${companyUid}`;
}
const createAlertRuleModel = (conn, sourceModel) => {
    function updateAlertRulePartial(alertRulePartial) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, helper_1.updatePartialOne)(conn, getAlertRuleUidKey(alertRulePartial.alertRuleUid), alertRulePartial);
            yield (0, helper_1.updatePartialOne)(conn, getAlertRuleCompanyUidKey(alertRulePartial.companyUid), alertRulePartial);
        });
    }
    function observeAlertRule(alertRuleKey) {
        const observable = (0, helper_1.observe)(conn, alertRuleKey);
        return (0, helpers_1.asyncMap)(observable, (changes) => __awaiter(this, void 0, void 0, function* () {
            const alertRule = yield (0, waitUntil_1.waitUntilNotNull)(() => __awaiter(this, void 0, void 0, function* () {
                return yield sourceModel.fetchByUid(changes.new_partial_val.alertRuleUid);
            }));
            return {
                old_val: { alertRuleUid: changes.new_partial_val.alertRuleUid },
                new_val: alertRule,
                clusterTime: changes.clusterTime,
            };
        }));
    }
    function computeAlertRulesStamp(alertRules) {
        return alertRules.reduce((stamp, alertRule) => {
            return stamp + (1 + (alertRule.history.length % 2));
        }, 0);
    }
    return {
        observeListByCompanyUidsAndOptions(companyUids, options, status) {
            return __awaiter(this, void 0, void 0, function* () {
                const grainObservable = (0, helpers_1.mergeObservables)(...companyUids.map((uid) => (0, helper_1.observe)(conn, getAlertRuleCompanyUidKey(uid))));
                let lastStamp = Math.round(Math.random() * 1e6);
                const fineObservable = (0, helpers_1.asyncMap)(grainObservable, (_changes) => __awaiter(this, void 0, void 0, function* () {
                    return yield sourceModel.fetchListByCompanyUidsAndOptions(companyUids, options, status);
                })).filter((alerts) => {
                    const currentStamp = computeAlertRulesStamp(alerts);
                    if (currentStamp !== lastStamp) {
                        lastStamp = currentStamp;
                        return true;
                    }
                    return false;
                });
                return fineObservable;
            });
        },
        observeByUid(alertRuleUid) {
            return __awaiter(this, void 0, void 0, function* () {
                return observeAlertRule(getAlertRuleUidKey(alertRuleUid));
            });
        },
        create(alertRuleUid, _name, companyUid, _createdAt, _originator) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAlertRulePartial({ alertRuleUid, companyUid });
            });
        },
        update(alertRuleRow, _values, _updatedAt, _originator) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAlertRulePartial({
                    alertRuleUid: alertRuleRow.alertRuleUid,
                    companyUid: alertRuleRow.companyUid,
                });
            });
        },
        archive(alertRuleRow, _archivedAt, _originator) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAlertRulePartial({
                    alertRuleUid: alertRuleRow.alertRuleUid,
                    companyUid: alertRuleRow.companyUid,
                });
            });
        },
        pause(alertRuleRow, _pausedAt, _originator) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAlertRulePartial({
                    alertRuleUid: alertRuleRow.alertRuleUid,
                    companyUid: alertRuleRow.companyUid,
                });
            });
        },
        unpause(alertRuleRow, _unpausedAt, _originator) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAlertRulePartial({
                    alertRuleUid: alertRuleRow.alertRuleUid,
                    companyUid: alertRuleRow.companyUid,
                });
            });
        },
    };
};
exports.createAlertRuleModel = createAlertRuleModel;
//# sourceMappingURL=alertRuleModel.js.map