"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAlertModel = void 0;
const helper_1 = require("../helper");
const helpers_1 = require("@signageos/lib/dist/Observable/helpers");
const waitUntil_1 = require("@signageos/lib/dist/DateTime/waitUntil");
const alertUidKeyPrefix = 'alert.alertUid';
function getAlertUidKey(uid) {
    return `${alertUidKeyPrefix}.${uid}`;
}
const alertOrganizationUidKeyPrefix = 'alert.organizationUid';
function getAlertOrganizationUidKey(organizationUid) {
    return `${alertOrganizationUidKeyPrefix}.${organizationUid}`;
}
const createAlertModel = (conn, sourceModel) => {
    function updateAlertPartial(alertPartial) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, helper_1.updatePartialOne)(conn, getAlertUidKey(alertPartial.alertUid), alertPartial);
            yield (0, helper_1.updatePartialOne)(conn, getAlertOrganizationUidKey(alertPartial.organizationUid), alertPartial);
        });
    }
    function observeAlert(alertKey) {
        const observable = (0, helper_1.observe)(conn, alertKey);
        return (0, helpers_1.asyncMap)(observable, (changes) => __awaiter(this, void 0, void 0, function* () {
            const alert = yield (0, waitUntil_1.waitUntilNotNull)(() => __awaiter(this, void 0, void 0, function* () {
                return yield sourceModel.fetchByUid(changes.new_partial_val.alertUid);
            }));
            return {
                old_val: { alertUid: changes.new_partial_val.alertUid },
                new_val: alert,
                clusterTime: changes.clusterTime,
            };
        }));
    }
    function computeAlertsStamp(alerts) {
        return alerts.reduce((stamp, alert, index) => {
            return stamp + (1 - 2 * (index % 2)) * alert.latelyChangedAt.getTime() * (1 + (alert.history.length % 2));
        }, 0);
    }
    return {
        observeListByOrganizations(organizations, filter, sorter, pagination) {
            return __awaiter(this, void 0, void 0, function* () {
                const grainObservable = (0, helpers_1.mergeObservables)(...organizations.map(({ uid }) => (0, helper_1.observe)(conn, getAlertOrganizationUidKey(uid))));
                let lastStamp = Math.round(Math.random() * 1e6);
                const fineObservable = (0, helpers_1.asyncMap)(grainObservable, (_changes) => __awaiter(this, void 0, void 0, function* () {
                    return yield sourceModel.fetchListByOrganizations(organizations, filter, sorter, pagination);
                })).filter((alerts) => {
                    const currentStamp = computeAlertsStamp(alerts);
                    if (currentStamp !== lastStamp) {
                        lastStamp = currentStamp;
                        return true;
                    }
                    return false;
                });
                return fineObservable;
            });
        },
        observeByUid(alertUid) {
            return __awaiter(this, void 0, void 0, function* () {
                return observeAlert(getAlertUidKey(alertUid));
            });
        },
        create(alertUid, organization, _description, _alertRule, _createdAt) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAlertPartial({ alertUid, organizationUid: organization.uid });
            });
        },
        updateLatelyProcessedAt(alertRow, _latelyProcessedAt) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAlertPartial({ alertUid: alertRow.alertUid, organizationUid: alertRow.organizationUid });
            });
        },
        updateDescription(alertRow, _description, _updatedAt, _originator) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAlertPartial({ alertUid: alertRow.alertUid, organizationUid: alertRow.organizationUid });
            });
        },
        assignDevice(alertRow, _deviceIdentityHash, _assignedAt) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAlertPartial({ alertUid: alertRow.alertUid, organizationUid: alertRow.organizationUid });
            });
        },
        unassignDevice(alertRow, _deviceIdentityHash, _assignedAt) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAlertPartial({ alertUid: alertRow.alertUid, organizationUid: alertRow.organizationUid });
            });
        },
        archive(alertRow, _archivedAt, _originator) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAlertPartial({ alertUid: alertRow.alertUid, organizationUid: alertRow.organizationUid });
            });
        },
        unarchive(alertRow, _unarchivedAt, _originator) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAlertPartial({ alertUid: alertRow.alertUid, organizationUid: alertRow.organizationUid });
            });
        },
        snooze(alertRow, _snoozeRule, _snoozedAt, _originator) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAlertPartial({ alertUid: alertRow.alertUid, organizationUid: alertRow.organizationUid });
            });
        },
        unsnooze(alertRow, _unsnoozedAt, _originator) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAlertPartial({ alertUid: alertRow.alertUid, organizationUid: alertRow.organizationUid });
            });
        },
        snoozeDevice(alertRow, _deviceIdentityHash, _snoozeRule, _snoozedAt, _originator) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAlertPartial({ alertUid: alertRow.alertUid, organizationUid: alertRow.organizationUid });
            });
        },
        unsnoozeDevice(alertRow, _deviceIdentityHash, _unsnoozedAt, _originator) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAlertPartial({ alertUid: alertRow.alertUid, organizationUid: alertRow.organizationUid });
            });
        },
    };
};
exports.createAlertModel = createAlertModel;
//# sourceMappingURL=alertModel.js.map