"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAccountModel = void 0;
const helpers_1 = require("@signageos/lib/dist/Observable/helpers");
const waitUntil_1 = require("@signageos/lib/dist/DateTime/waitUntil");
const helper_1 = require("../helper");
const observation_1 = require("../../Helpers/observation");
const wait_1 = require("@signageos/lib/dist/Timer/wait");
const accountIdKeyPrefix = 'account.id';
function getAccountIdKey(id) {
    return `${accountIdKeyPrefix}.${id}`;
}
const accountUsernameKeyPrefix = 'account.username';
function getAccountUsernameKey(username) {
    return `${accountUsernameKeyPrefix}.${username}`;
}
const accountSessionUidKeyPrefix = 'account.sessionUid';
function getAccountSessionUidKey(sessionUid) {
    return `${accountSessionUidKeyPrefix}.${sessionUid}`;
}
const accountsAllKey = 'account.all';
const createAccountModel = (conn, sourceModel) => {
    function updateAccountPartial(accountPartial) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, helper_1.updatePartialOne)(conn, getAccountIdKey(accountPartial.id), accountPartial);
            if (typeof accountPartial.username === 'string') {
                yield (0, helper_1.updatePartialOne)(conn, getAccountUsernameKey(accountPartial.username), accountPartial);
            }
            yield (0, helper_1.updatePartialOne)(conn, accountsAllKey, accountPartial);
        });
    }
    function observeAccount(accountKey) {
        const observable = (0, helper_1.observe)(conn, accountKey);
        return (0, helpers_1.asyncMap)(observable, (changes) => __awaiter(this, void 0, void 0, function* () {
            const account = yield (0, waitUntil_1.waitUntilNotNull)(() => __awaiter(this, void 0, void 0, function* () {
                return yield sourceModel.fetchById(changes.new_partial_val.id);
            }));
            if (!account) {
                throw new Error(`Account doesn't exist`);
            }
            return {
                old_val: account,
                new_val: Object.assign(Object.assign({}, account), changes.new_partial_val),
                clusterTime: changes.clusterTime,
            };
        }));
    }
    return {
        create({ id, username }) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAccountPartial({ id, username });
            });
        },
        updateEmail(accountRow, email) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAccountPartial({
                    id: accountRow.id,
                    username: accountRow.username,
                    email,
                });
            });
        },
        updatePasswordAndSalt(accountRow, password, salt) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAccountPartial({
                    id: accountRow.id,
                    username: accountRow.username,
                    password,
                    salt,
                });
            });
        },
        updateFirstNameAndLastName(accountRow, firstname, lastname) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAccountPartial({
                    id: accountRow.id,
                    username: accountRow.username,
                    firstname,
                    lastname,
                });
            });
        },
        updateAccessLevel(accountRow, accessLevel) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAccountPartial({
                    id: accountRow.id,
                    username: accountRow.username,
                    accessLevel,
                });
            });
        },
        addSession(accountRow, sessionUid, createdAt) {
            return __awaiter(this, void 0, void 0, function* () {
                const existingAccount = yield sourceModel.fetchById(accountRow.id);
                if (!existingAccount) {
                    throw new Error(`Account doesn't exist`);
                }
                const newAccountPartial = {
                    id: accountRow.id,
                    username: accountRow.username,
                    sessions: [
                        // filter out when already exists
                        ...(existingAccount.sessions || []).filter((session) => session.sessionUid !== sessionUid),
                        { sessionUid, createdAt },
                    ],
                };
                yield updateAccountPartial(newAccountPartial);
                // used only for waitForFirst
                yield (0, helper_1.updatePartialOne)(conn, getAccountSessionUidKey(sessionUid), newAccountPartial);
            });
        },
        removeSession(accountRow, sessionUid) {
            return __awaiter(this, void 0, void 0, function* () {
                const existingAccount = yield sourceModel.fetchById(accountRow.id);
                if (!existingAccount) {
                    throw new Error(`Account doesn't exist`);
                }
                const newAccountPartial = {
                    id: accountRow.id,
                    username: accountRow.username,
                    sessions: existingAccount.sessions.filter((session) => session.sessionUid !== sessionUid),
                };
                yield updateAccountPartial(newAccountPartial);
            });
        },
        removeAllSessions(accountRow) {
            return __awaiter(this, void 0, void 0, function* () {
                const existingAccount = yield sourceModel.fetchById(accountRow.id);
                if (!existingAccount) {
                    throw new Error(`Account doesn't exist`);
                }
                const newAccountPartial = {
                    id: accountRow.id,
                    username: accountRow.username,
                    sessions: [],
                };
                yield updateAccountPartial(newAccountPartial);
            });
        },
        setActive(accountRow, active) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAccountPartial({
                    id: accountRow.id,
                    username: accountRow.username,
                    isActive: active,
                });
            });
        },
        addPrivilege(accountRow, _privilege) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAccountPartial({
                    id: accountRow.id,
                    username: accountRow.username,
                });
            });
        },
        removePrivilege(accountRow, _privilege) {
            return __awaiter(this, void 0, void 0, function* () {
                yield updateAccountPartial({
                    id: accountRow.id,
                    username: accountRow.username,
                });
            });
        },
        observeById(id) {
            return __awaiter(this, void 0, void 0, function* () {
                return observeAccount(getAccountIdKey(id));
            });
        },
        observeAllList() {
            return __awaiter(this, void 0, void 0, function* () {
                return observeAccount(accountsAllKey);
            });
        },
        observeSortedList(options) {
            return __awaiter(this, void 0, void 0, function* () {
                const observable = (0, helper_1.observe)(conn, accountsAllKey);
                return (0, helpers_1.asyncMap)(observable, (_changes) => __awaiter(this, void 0, void 0, function* () {
                    yield (0, wait_1.default)(200);
                    return yield sourceModel.fetchSortedList(options);
                }));
            });
        },
        waitByUsername(username) {
            return __awaiter(this, void 0, void 0, function* () {
                const observable = observeAccount(getAccountUsernameKey(username));
                const firstPromise = (0, observation_1.waitForFirstNonNull)(observable);
                const existingAccount = yield sourceModel.fetchByUsername(username);
                if (existingAccount) {
                    return existingAccount;
                }
                const changes = yield firstPromise;
                return changes.new_val;
            });
        },
        waitBySessionUid(sessionUid) {
            return __awaiter(this, void 0, void 0, function* () {
                const observable = observeAccount(getAccountSessionUidKey(sessionUid));
                const firstPromise = (0, observation_1.waitForFirstNonNull)(observable);
                const existingAccount = yield sourceModel.fetchBySessionUid(sessionUid);
                if (existingAccount) {
                    return existingAccount;
                }
                const changes = yield firstPromise;
                return changes.new_val;
            });
        },
    };
};
exports.createAccountModel = createAccountModel;
//# sourceMappingURL=accountModel.js.map