import { Collection, Filter, Timestamp, ClientSession, Document } from 'mongodb';
import { IStreamChange } from './changeStreams';
export interface ISimpleChangeStream<TDocument> {
    on(event: 'change', listener: (streamChange: IStreamChange<TDocument>) => void): void;
    removeListener(event: 'change', listener: (streamChange: IStreamChange<TDocument>) => void): void;
    removeAllListeners(event?: 'change'): void;
    close(): Promise<void>;
}
export interface IStreamWatcher<TDocument extends Document> {
    watchDeleteAndRemove(collection: Collection<TDocument>, changeStreamFilter: Filter<IStreamChange<TDocument>>, removableAndDeletableIds: string[], options: IWatchOptions): ISimpleChangeStream<TDocument>;
    watchUpserts(collection: Collection<TDocument>, changeStreamFilter: Filter<IStreamChange<TDocument>>, options: IWatchOptions): ISimpleChangeStream<TDocument>;
    watchDeletions(collection: Collection<TDocument>, removableAndDeletableIds: string[], options: IWatchOptions): ISimpleChangeStream<TDocument>;
    watchRemoves(collection: Collection<TDocument>, changeStreamFilter: Filter<IStreamChange<TDocument>>, removableAndDeletableIds: string[], options: IWatchOptions): ISimpleChangeStream<TDocument>;
}
export interface IWatchOptions {
    startAtOperationTime: Timestamp;
    session?: ClientSession;
}
//# sourceMappingURL=watchers.d.ts.map