"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mapIPaginatorToPaginationAndSorting = exports.isPaginatorOfOffsetType = exports.isPaginatorOfTimeType = void 0;
const paginationTypes_1 = require("../Lib/Pagination/paginationTypes");
/**
 * @deprecated use PaginationAndSorting
 * TODO remove all usage of this and then delete it
 */
const isPaginatorOfTimeType = (pagination) => {
    return pagination.since !== undefined || pagination.until !== undefined;
};
exports.isPaginatorOfTimeType = isPaginatorOfTimeType;
/**
 * @deprecated use PaginationAndSorting
 * TODO remove all usage of this and then delete it
 */
const isPaginatorOfOffsetType = (pagination) => {
    return pagination.offset !== undefined;
};
exports.isPaginatorOfOffsetType = isPaginatorOfOffsetType;
/**
 * @deprecated This is just a helper function to map the old pagination system to the new one.
 * TODO: remove all usage of IPaginator and then delete it
 */
function mapIPaginatorToPaginationAndSorting(pagination) {
    if (!pagination) {
        return undefined;
    }
    let mappedPagination = undefined;
    let mappedSorting = undefined;
    if ((0, paginationTypes_1.isLinkPagination)(pagination)) {
        mappedPagination = {
            since: pagination.since,
            until: pagination.until,
        };
    }
    if ((0, paginationTypes_1.isOffsetPagination)(pagination)) {
        mappedPagination = {
            offset: pagination.offset,
            limit: pagination.limit,
        };
    }
    if (pagination.sortKey) {
        mappedSorting = {
            field: pagination.sortKey,
            order: pagination.descending ? paginationTypes_1.SortOrder.DESC : paginationTypes_1.SortOrder.ASC,
        };
    }
    return mappedPagination || mappedSorting
        ? {
            pagination: mappedPagination,
            sorting: mappedSorting,
        }
        : undefined;
}
exports.mapIPaginatorToPaginationAndSorting = mapIPaginatorToPaginationAndSorting;
//# sourceMappingURL=paginatorHelper.js.map