/// <reference types="lib.es2017.observable" />
import { Collection, Filter, ClientSession, Timestamp, Document } from 'mongodb';
import IChanges from '../IChanges';
import { IStreamWatcher } from './watchers';
export interface ISimpleObserveOptions<TDocument extends Document> {
    session?: ClientSession;
    streamWatcher?: IStreamWatcher<TDocument>;
    startAtOperationTime?: Timestamp;
    fields?: object;
}
export interface IObserveOptions<TDocument extends Document> extends ISimpleObserveOptions<TDocument> {
    recoverIntervalMs?: number;
}
export declare function observe<TDocument extends Document>(collection: Collection<TDocument>, filter: Filter<TDocument>, options?: IObserveOptions<TDocument>): Promise<Observable<IChanges<TDocument>, Error>>;
export declare function observeSimple<TDocument extends Document>(collection: Collection<TDocument>, filter: Filter<TDocument>, options?: ISimpleObserveOptions<TDocument>): Promise<Observable<IChanges<TDocument>, Error>>;
export declare function observeWithInitialData<TDocument extends Document>(collection: Collection<TDocument>, filter: Filter<TDocument>, options?: IObserveOptions<TDocument>, initialData?: boolean): Promise<Observable<IChanges<TDocument>, Error>>;
//# sourceMappingURL=observation.d.ts.map