"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getReversedSubCondition = exports.getReversedTopLevelCondition = void 0;
function getReversedTopLevelCondition(changeStreamFilter) {
    const keys = Object.keys(changeStreamFilter);
    // this If is only to get rid of unnecessary $or in one attribute statements
    if (keys.length === 1) {
        const key = keys[0];
        return { [key]: getReversedSubCondition(changeStreamFilter[key]) };
    }
    return {
        $or: keys.map((key) => {
            if (key.search(/\$or/gi) >= 0) {
                return {
                    $and: changeStreamFilter[key].map((value) => {
                        return getReversedTopLevelCondition(value);
                    }),
                };
            }
            return { [key]: getReversedSubCondition(changeStreamFilter[key]) };
        }),
    };
}
exports.getReversedTopLevelCondition = getReversedTopLevelCondition;
function getReversedSubCondition(condition) {
    if (typeof condition === 'object') {
        return { $not: condition };
    }
    else if (typeof condition === 'string' || typeof condition === 'number') {
        return { $ne: condition };
    }
    else {
        throw new Error(`Not supported condition construct: ${JSON.stringify(condition)}`);
    }
}
exports.getReversedSubCondition = getReversedSubCondition;
//# sourceMappingURL=conditions.js.map