"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const mongodb_1 = require("mongodb");
const CombinedChangeStream_1 = require("../CombinedChangeStream");
const conditions_1 = require("../conditions");
class SimpleStreamWatcher {
    watchDeleteAndRemove(collection, changeStreamFilter, removableAndDeletableIds, options) {
        const deleteStream = this.watchDeletions(collection, removableAndDeletableIds, options);
        const removeStream = this.watchRemoves(collection, changeStreamFilter, removableAndDeletableIds, options);
        return new CombinedChangeStream_1.default(deleteStream, removeStream);
    }
    watchUpserts(collection, changeStreamFilter, options) {
        return collection.watch([
            {
                $match: Object.assign(Object.assign({}, changeStreamFilter), { operationType: { $in: ['insert', 'replace', 'update'] } }),
            },
        ], Object.assign({ fullDocument: 'updateLookup' }, options));
    }
    watchDeletions(collection, removableAndDeletableIds, options) {
        const removableAndDeletableObjectIds = removableAndDeletableIds.map((id) => new mongodb_1.ObjectId(id));
        return collection.watch([
            {
                $match: {
                    'documentKey._id': { $in: removableAndDeletableObjectIds },
                    operationType: 'delete',
                },
            },
        ], Object.assign({ fullDocument: 'updateLookup' }, options));
    }
    watchRemoves(collection, changeStreamFilter, removableAndDeletableIds, options) {
        const removableAndDeletableObjectIds = removableAndDeletableIds.map((id) => new mongodb_1.ObjectId(id));
        const changeStreamFilterReversed = (0, conditions_1.getReversedTopLevelCondition)(changeStreamFilter);
        return collection.watch([
            {
                $match: Object.assign(Object.assign({}, changeStreamFilterReversed), { 'documentKey._id': { $in: removableAndDeletableObjectIds }, operationType: { $in: ['replace', 'update'] } }),
            },
        ], Object.assign({ fullDocument: 'updateLookup' }, options));
    }
}
exports.default = SimpleStreamWatcher;
//# sourceMappingURL=SimpleStreamWatcher.js.map