import { IStreamWatcher, IWatchOptions } from '../watchers';
import { Collection, Filter, Document } from 'mongodb';
import CombinedChangeStream from '../CombinedChangeStream';
import { IStreamChange } from '../changeStreams';
export default class SimpleStreamWatcher<TDocument extends Document> implements IStreamWatcher<TDocument> {
    watchDeleteAndRemove(collection: Collection<TDocument>, changeStreamFilter: Filter<IStreamChange<TDocument>>, removableAndDeletableIds: string[], options: IWatchOptions): CombinedChangeStream<unknown>;
    watchUpserts(collection: Collection<TDocument>, changeStreamFilter: Filter<IStreamChange<TDocument>>, options: IWatchOptions): import("mongodb").ChangeStream<TDocument, import("mongodb").ChangeStreamDocument<TDocument>>;
    watchDeletions(collection: Collection<TDocument>, removableAndDeletableIds: string[], options: IWatchOptions): import("mongodb").ChangeStream<TDocument, import("mongodb").ChangeStreamDocument<TDocument>>;
    watchRemoves(collection: Collection<TDocument>, changeStreamFilter: Filter<IStreamChange<TDocument>>, removableAndDeletableIds: string[], options: IWatchOptions): import("mongodb").ChangeStream<TDocument, import("mongodb").ChangeStreamDocument<TDocument>>;
}
//# sourceMappingURL=SimpleStreamWatcher.d.ts.map