import { IStreamWatcher, IWatchOptions } from '../watchers';
import { Collection, Filter, Document } from 'mongodb';
import CombinedChangeStream from '../CombinedChangeStream';
import { IStreamChange } from '../changeStreams';
import ProxyChangeStream from '../ProxyChangeStream';
export default class IntervalStreamWatcher<TDocument extends Document> implements IStreamWatcher<TDocument> {
    private intervalHandler;
    private collectionStatesMap;
    constructor(intervalMs: number);
    watchDeleteAndRemove(collection: Collection<TDocument>, changeStreamFilter: Filter<IStreamChange<TDocument>>, removableAndDeletableIds: string[], options: IWatchOptions): CombinedChangeStream<unknown>;
    watchUpserts(collection: Collection<TDocument>, changeStreamFilter: Filter<IStreamChange<TDocument>>, options: IWatchOptions): ProxyChangeStream<TDocument>;
    watchDeletions(collection: Collection<TDocument>, removableAndDeletableIds: string[], options: IWatchOptions): ProxyChangeStream<TDocument>;
    watchRemoves(collection: Collection<TDocument>, changeStreamFilter: Filter<IStreamChange<TDocument>>, removableAndDeletableIds: string[], options: IWatchOptions): ProxyChangeStream<TDocument>;
    drain(): Promise<void>;
    private setupCollectionFilter;
    private removeFilterMutation;
    private addFilterMutation;
    private start;
    private processCollectionChanges;
    private handleStreamChange;
    private fillFiltersStartAtOperationTime;
    private closeAndRemoveChangeStream;
    private getChangeStreamOptions;
    private cleanupCollectionState;
    private ensureCollectionState;
    private createCollectionState;
    private getTheLowestStartAtOperationTime;
    private getAnyFilterCondition;
    private warnPossibleMemoryLeak;
}
//# sourceMappingURL=IntervalStreamWatcher.d.ts.map