"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const _ = require("lodash");
const Debug = require("debug");
const debug = Debug('@signageos/user-domain-model:MongoDB:MemoryObservationManager');
class MemoryObservationManager {
    constructor(currentIds, emitChanges, onNew) {
        this.emitChanges = emitChanges;
        this.onNew = onNew;
        this.updateAndNewListener = (streamChange) => {
            const affectedId = `${streamChange.documentKey._id}`;
            if (typeof this.stopAdditionalDeleteAndRemoveCallbacks[affectedId] === 'undefined') {
                this.stopAdditionalDeleteAndRemoveCallbacks[affectedId] = this.onNew(affectedId, streamChange.clusterTime);
                debug('observation new', streamChange);
                this.emitChanges({
                    old_val: null,
                    new_val: streamChange.fullDocument,
                    clusterTime: streamChange.clusterTime,
                });
            }
            else {
                debug('observation update', streamChange);
                this.emitChanges({
                    old_val: this.getOldDocument(streamChange.documentKey._id),
                    new_val: streamChange.fullDocument,
                    clusterTime: streamChange.clusterTime,
                });
            }
        };
        this.deleteOrRemoveListener = (streamChange) => {
            const affectedId = `${streamChange.documentKey._id}`;
            if (typeof this.stopAdditionalDeleteAndRemoveCallbacks[affectedId] !== 'undefined') {
                this.stopAdditionalDeleteAndRemoveCallbacks[affectedId](); // warn: not await
                delete this.stopAdditionalDeleteAndRemoveCallbacks[affectedId];
                debug('observation delete or remove', streamChange);
                this.emitChanges({
                    old_val: this.getOldDocument(streamChange.documentKey._id),
                    new_val: null,
                    clusterTime: streamChange.clusterTime,
                });
            }
        };
        this.drain = () => {
            const callbacks = _.values(this.stopAdditionalDeleteAndRemoveCallbacks);
            return Promise.all(callbacks.map((callback) => callback()));
        };
        this.stopAdditionalDeleteAndRemoveCallbacks = currentIds.reduce((callbacks, id) => (Object.assign(Object.assign({}, callbacks), { [id]: () => __awaiter(this, void 0, void 0, function* () { return null; }) })), {});
    }
    getOldDocument(documentId) {
        return { _id: documentId }; // TODO load from memory
    }
}
exports.default = MemoryObservationManager;
//# sourceMappingURL=MemoryObservationManager.js.map