"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createWhiteLabelSettingsModel = exports.prepareWhiteLabelSettingsTable = exports.whiteLabelSettingsCollection = void 0;
const collections_1 = require("../Lib/collections");
const model_1 = require("../Lib/Model/model");
const whiteLabelSettingsCollection = (conn) => conn.connection.collection(collections_1.Collection.WhiteLabelSettings);
exports.whiteLabelSettingsCollection = whiteLabelSettingsCollection;
const prepareWhiteLabelSettingsTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield (0, exports.whiteLabelSettingsCollection)(conn).createIndex('uid', {
        name: 'uid',
        unique: true,
        background: true,
    });
});
exports.prepareWhiteLabelSettingsTable = prepareWhiteLabelSettingsTable;
const createWhiteLabelSettingsModel = (conn) => (Object.assign(Object.assign({}, (0, model_1.createModel)({
    conn,
    collection: collections_1.Collection.WhiteLabelSettings,
})), { fetchByCustomDomain(customDomain) {
        return __awaiter(this, void 0, void 0, function* () {
            return (0, exports.whiteLabelSettingsCollection)(conn).findOne({ customDomain }, { session: conn.session });
        });
    } }));
exports.createWhiteLabelSettingsModel = createWhiteLabelSettingsModel;
//# sourceMappingURL=whiteLabelSettingsModel.js.map