"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createTimingModel = exports.prepareTimingTable = void 0;
const lodash_1 = require("lodash");
const escape_1 = require("@signageos/lib/dist/MongoDB/escape");
const collections_1 = require("../Lib/collections");
const paginationTypes_1 = require("../../Lib/Pagination/paginationTypes");
const pagination_1 = require("../../Lib/Pagination/pagination");
const utils_1 = require("../Lib/utils");
const timingCollection = (conn) => conn.connection.collection(collections_1.Collection.Timing);
const prepareTimingTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield timingCollection(conn).createIndex('uid', { name: 'uid', unique: true, background: true });
    yield timingCollection(conn).createIndex('appletUid', { name: 'appletUid', background: true });
    yield timingCollection(conn).createIndex('deviceIdentityHash', { name: 'deviceIdentityHash', background: true });
    yield timingCollection(conn).createIndex({ deviceIdentityHash: 1, endsAt: -1 }, { name: 'deviceIdentityHash_endsAt', background: true });
});
exports.prepareTimingTable = prepareTimingTable;
function unescapeTimingOrNull(timing) {
    return timing ? unescapeTiming(timing) : null;
}
function unescapeTiming(timing) {
    return Object.assign(Object.assign({}, timing), { configuration: (0, escape_1.unescapeObject)(timing.configuration) });
}
const createTimingModel = (conn) => ({
    create(appletRow, deviceRow, values) {
        return __awaiter(this, void 0, void 0, function* () {
            const timing = {
                uid: values.uid,
                appletUid: appletRow.uid,
                deviceIdentityHash: deviceRow.identityHash,
                createdAt: values.createdAt,
                updatedAt: values.createdAt,
                startsAt: values.startsAt,
                endsAt: values.endsAt,
                configuration: (0, escape_1.escapeObject)(values.configuration),
                appletVersion: values.appletVersion,
                finishEvent: values.finishEvent,
                position: values.position,
                active: values.active,
            };
            yield timingCollection(conn).insertOne(timing, { session: conn.session });
        });
    },
    update(timingRow, values) {
        return __awaiter(this, void 0, void 0, function* () {
            const updateValues = (0, lodash_1.pickBy)(Object.assign(Object.assign({}, (0, lodash_1.pick)(values, ['updatedAt', 'startsAt', 'endsAt', 'configuration', 'appletVersion', 'finishEvent', 'position', 'active'])), { configuration: values.configuration ? (0, escape_1.escapeObject)(values.configuration) : undefined }), (value) => !(0, lodash_1.isUndefined)(value));
            yield timingCollection(conn).updateOne({ uid: timingRow.uid }, {
                $set: Object.assign({}, updateValues),
            }, { session: conn.session });
        });
    },
    remove(timingRow) {
        return __awaiter(this, void 0, void 0, function* () {
            yield timingCollection(conn).deleteOne({ uid: timingRow.uid }, { session: conn.session });
        });
    },
    fetchByUid(uid) {
        return __awaiter(this, void 0, void 0, function* () {
            const timing = yield timingCollection(conn).findOne({ uid }, { session: conn.session });
            return unescapeTimingOrNull(timing);
        });
    },
    fetchList({ devices, applet, active, pagination, sorting }) {
        return __awaiter(this, void 0, void 0, function* () {
            const matcher = {};
            if (devices) {
                matcher.deviceIdentityHash = { $in: devices.map((device) => device.identityHash) };
            }
            if (applet) {
                matcher.appletUid = applet.uid;
            }
            if (typeof active !== 'undefined') {
                matcher.active = active;
            }
            const defaultSorting = {
                field: 'createdAt',
                order: paginationTypes_1.SortOrder.DESC,
            };
            const sorter = (0, pagination_1.getSorting)({ defaultSorting, sorting });
            const pipeline = (0, utils_1.getPipeline)({ matcher, sorting: sorter, pagination });
            const timings = yield timingCollection(conn).aggregate(pipeline, { session: conn.session }).toArray();
            return timings.map(unescapeTiming);
        });
    },
    count({ applet }) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield timingCollection(conn).countDocuments({
                appletUid: applet.uid,
            }, { session: conn.session });
        });
    },
});
exports.createTimingModel = createTimingModel;
//# sourceMappingURL=timingModel.js.map