"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createTimingCommandModel = exports.prepareTimingCommandTable = exports.timingCommandCollection = void 0;
const escape_1 = require("../../../MongoDB/escape");
const collections_1 = require("../../Lib/collections");
const timingCommand_utils_1 = require("../../../Schema/Timing/Command/timingCommand.utils");
const utils_1 = require("../../Lib/utils");
const timingCommandModelUtils_1 = require("./timingCommandModelUtils");
const timingCommandCollection = (conn) => conn.connection.collection(collections_1.Collection.TimingCommand, {
    writeConcern: {
        w: 1,
    },
});
exports.timingCommandCollection = timingCommandCollection;
const prepareTimingCommandTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield (0, exports.timingCommandCollection)(conn).createIndex({ id: 1 }, { name: 'id', unique: true, background: true });
    yield (0, exports.timingCommandCollection)(conn).createIndex({ deviceIdentityHash: 1 }, { name: 'deviceIdentityHash', background: true });
    yield (0, exports.timingCommandCollection)(conn).createIndex({ receivedAt: 1 }, { name: 'receivedAt', background: true, expireAfterSeconds: 86400 });
    yield (0, exports.timingCommandCollection)(conn).createIndex({ recordedAt: 1 }, { name: 'recordedAt', background: true });
    yield (0, exports.timingCommandCollection)(conn).createIndex({ appletUid: 1 }, { name: 'appletUid', background: true });
    yield (0, exports.timingCommandCollection)(conn).createIndex({ 'commandPayload.type': 1 }, { name: 'commandPayload_type', background: true });
    yield (0, exports.timingCommandCollection)(conn).createIndex({ deviceIdentityHash: 1, receivedAt: 1 }, { name: 'deviceIdentityHash_receivedAt', background: true });
    yield (0, exports.timingCommandCollection)(conn).createIndex({ deviceIdentityHash: 1, receivedAt: -1 }, { name: 'deviceIdentityHash_receivedAt-1', background: true });
    yield (0, exports.timingCommandCollection)(conn).createIndex({ deviceIdentityHash: 1, recordedAt: 1 }, { name: 'deviceIdentityHash_recordedAt', background: true });
    yield (0, exports.timingCommandCollection)(conn).createIndex({ deviceIdentityHash: 1, recordedAt: -1 }, { name: 'deviceIdentityHash_recordedAt-1', background: true });
    yield (0, exports.timingCommandCollection)(conn).createIndex({ deviceIdentityHash: 1, appletUid: 1 }, { name: 'deviceIdentityHash_appletUid', background: true });
    yield (0, exports.timingCommandCollection)(conn).createIndex({ deviceIdentityHash: 1, 'commandPayload.type': 1 }, { name: 'deviceIdentityHash_commandPayload_type', background: true });
    yield (0, exports.timingCommandCollection)(conn).createIndex({ deviceIdentityHash: 1, 'commandPayload.type': 1, receivedAt: -1 }, { name: 'deviceIdentityHash_commandPayload_type_receivedAt', background: true });
});
exports.prepareTimingCommandTable = prepareTimingCommandTable;
function mapRow(row) {
    return Object.assign(Object.assign({}, row), { commandPayload: (0, escape_1.unescapeObject)(row.commandPayload) });
}
function getFilterByDeviceAndPropertyFilter(device, propertyFilter) {
    const filter = [];
    filter.push({ deviceIdentityHash: device.identityHash });
    if (typeof propertyFilter.appletUid !== 'undefined') {
        filter.push({ appletUid: propertyFilter.appletUid });
    }
    if (propertyFilter.type !== undefined) {
        filter.push({ 'commandPayload.type': { $regex: `^${propertyFilter.type}` } });
    }
    if (propertyFilter.excludeType !== undefined) {
        filter.push({ 'commandPayload.type': { $regex: `^(?!${propertyFilter.excludeType})` } });
    }
    if (typeof propertyFilter.receivedSince !== 'undefined') {
        filter.push({ receivedAt: { $gte: propertyFilter.receivedSince } });
    }
    if (typeof propertyFilter.receivedUntil !== 'undefined') {
        filter.push({ receivedAt: { $lt: propertyFilter.receivedUntil } });
    }
    if (typeof propertyFilter.recordedSince !== 'undefined') {
        filter.push({ recordedAt: { $gte: propertyFilter.recordedSince } });
    }
    if (typeof propertyFilter.recordedUntil !== 'undefined') {
        filter.push({ recordedAt: { $lt: propertyFilter.recordedUntil } });
    }
    if (typeof propertyFilter.payloadKeyValue !== 'undefined') {
        filter.push((0, timingCommandModelUtils_1.partialObjectToMongoMatchQuery)(propertyFilter.payloadKeyValue, 'commandPayload'));
    }
    return filter;
}
const createTimingCommandModel = (conn) => ({
    fetchById(id) {
        return __awaiter(this, void 0, void 0, function* () {
            const timingCommand = yield (0, exports.timingCommandCollection)(conn).findOne({ id });
            return timingCommand ? mapRow(timingCommand) : null;
        });
    },
    fetchListByDeviceAndPropertyFilter(device, propertyFilter, pagination, customSorting) {
        return __awaiter(this, void 0, void 0, function* () {
            const filter = getFilterByDeviceAndPropertyFilter(device, propertyFilter);
            const matcher = { $and: filter };
            const sorting = (0, timingCommand_utils_1.getSorting)(customSorting);
            const pipeline = (0, utils_1.getPipeline)({ matcher, sorting, pagination });
            const rows = yield (0, exports.timingCommandCollection)(conn).aggregate(pipeline, { session: conn.session }).toArray();
            return rows.map(mapRow);
        });
    },
    fetchUniqueTypesByDevice({ device, receivedSince, receivedUntil }) {
        return __awaiter(this, void 0, void 0, function* () {
            const filter = [];
            filter.push({ deviceIdentityHash: device.identityHash });
            if (typeof receivedSince !== 'undefined') {
                filter.push({ receivedAt: { $gte: receivedSince } });
            }
            if (typeof receivedUntil !== 'undefined') {
                filter.push({ receivedAt: { $lt: receivedUntil } });
            }
            // TODO remove as any
            // "as any" is a huge crime but I'm running out of time.
            // It started throwing TS error after upgrading mongoose but the tests are still passing
            return yield (0, exports.timingCommandCollection)(conn).distinct('commandPayload.type', { $and: filter });
        });
    },
    countByDeviceAndPropertyFilter(device, propertyFilter) {
        return __awaiter(this, void 0, void 0, function* () {
            const filter = getFilterByDeviceAndPropertyFilter(device, propertyFilter);
            // TODO remove as any
            // "as any" is a huge crime but I'm running out of time.
            // It started throwing TS error after upgrading mongoose but the tests are still passing
            const query = (0, exports.timingCommandCollection)(conn).count({ $and: filter });
            return query;
        });
    },
    create(timingCommand) {
        return __awaiter(this, void 0, void 0, function* () {
            const newRow = Object.assign(Object.assign({}, timingCommand), { commandPayload: (0, escape_1.escapeObject)(timingCommand.commandPayload) });
            yield (0, exports.timingCommandCollection)(conn).replaceOne({ id: newRow.id }, newRow, { session: conn.session, upsert: true });
        });
    },
    createMany(timingCommands) {
        return __awaiter(this, void 0, void 0, function* () {
            const rows = timingCommands.map((timingCommand) => (Object.assign(Object.assign({}, timingCommand), { commandPayload: (0, escape_1.escapeObject)(timingCommand.commandPayload) })));
            yield (0, exports.timingCommandCollection)(conn).insertMany(rows);
        });
    },
    deleteReceivedUntil(_receivedUntil) {
        return __awaiter(this, void 0, void 0, function* () {
            // Not necessary in mongodb to remove old rows, because of expireAfterSeconds index on receivedAt
        });
    },
});
exports.createTimingCommandModel = createTimingCommandModel;
//# sourceMappingURL=timingCommandModel.js.map