"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createThirdPartyCredentialsModel = exports.prepareThirdPartyCredentialsTable = exports.thirdPartyCredentialsCollection = void 0;
const collections_1 = require("../Lib/collections");
const modelReadable_1 = require("../Lib/Model/modelReadable");
const modelDeletable_1 = require("../Lib/Model/modelDeletable");
const modelUpdatable_1 = require("../Lib/Model/modelUpdatable");
const modelCreatable_1 = require("../Lib/Model/modelCreatable");
const paginationTypes_1 = require("../../Lib/Pagination/paginationTypes");
const pagination_1 = require("../../Lib/Pagination/pagination");
const utils_1 = require("../Lib/utils");
const thirdPartyCredentialsCollection = (conn) => conn.connection.collection(collections_1.Collection.ThirdPartyCredentials);
exports.thirdPartyCredentialsCollection = thirdPartyCredentialsCollection;
const prepareThirdPartyCredentialsTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield (0, exports.thirdPartyCredentialsCollection)(conn).createIndex('uid', { name: 'uid', unique: true, background: true });
    yield (0, exports.thirdPartyCredentialsCollection)(conn).createIndex('organizationUid', { name: 'organizationUid', background: true });
    yield (0, exports.thirdPartyCredentialsCollection)(conn).createIndex('type', { name: 'type', background: true });
});
exports.prepareThirdPartyCredentialsTable = prepareThirdPartyCredentialsTable;
const createThirdPartyCredentialsModel = (conn) => (Object.assign(Object.assign(Object.assign(Object.assign(Object.assign({}, (0, modelCreatable_1.createModelCreatable)({ conn, collection: collections_1.Collection.ThirdPartyCredentials })), (0, modelReadable_1.createModelReadable)({ conn, collection: collections_1.Collection.ThirdPartyCredentials })), (0, modelUpdatable_1.createModelUpdatable)({ conn, collection: collections_1.Collection.ThirdPartyCredentials })), (0, modelDeletable_1.createModelDeletable)({ conn, collection: collections_1.Collection.ThirdPartyCredentials })), { fetchListByFilter: ({ filter, sorting, pagination }) => __awaiter(void 0, void 0, void 0, function* () {
        const matcher = {};
        if (filter.organizationUids) {
            matcher.organizationUid = { $in: filter.organizationUids };
        }
        if (filter.types) {
            matcher.type = { $in: filter.types };
        }
        const defaultSorting = {
            field: 'createdAt',
            order: paginationTypes_1.SortOrder.DESC,
        };
        const sorter = (0, pagination_1.getSorting)({ defaultSorting, sorting });
        const pipeline = (0, utils_1.getPipeline)({ matcher, sorting: sorter, pagination });
        return yield (0, exports.thirdPartyCredentialsCollection)(conn).aggregate(pipeline, { session: conn.session }).toArray();
    }) }));
exports.createThirdPartyCredentialsModel = createThirdPartyCredentialsModel;
//# sourceMappingURL=thirdPartyCredentialsModel.js.map