"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createTermsAndConditionsVersionModel = exports.prepareTermsAndConditionsVersionTable = void 0;
const collections_1 = require("../Lib/collections");
const model_1 = require("../Lib/Model/model");
const termsAndConditionsVersionCollection = (conn) => conn.connection.collection(collections_1.Collection.TermsAndConditionsVersion);
const prepareTermsAndConditionsVersionTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield termsAndConditionsVersionCollection(conn).createIndex('uid', {
        name: 'uid',
        unique: true,
        background: true,
    });
});
exports.prepareTermsAndConditionsVersionTable = prepareTermsAndConditionsVersionTable;
const createTermsAndConditionsVersionModel = (conn) => (Object.assign(Object.assign({}, (0, model_1.createModel)({
    conn,
    collection: collections_1.Collection.TermsAndConditionsVersion,
})), { fetchLatestByTermsAndConditionsUid({ termsAndConditionsUid }) {
        return __awaiter(this, void 0, void 0, function* () {
            const lastTermsAndConditionsVersion = yield termsAndConditionsVersionCollection(conn)
                .aggregate([{ $match: { termsAndConditionsUid } }, { $sort: { createdAt: -1 } }])
                .toArray();
            return !lastTermsAndConditionsVersion ? null : lastTermsAndConditionsVersion[0];
        });
    } }));
exports.createTermsAndConditionsVersionModel = createTermsAndConditionsVersionModel;
//# sourceMappingURL=termsAndConditionsVersionModel.js.map