"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createTermsAndConditionsModel = exports.prepareTermsAndConditionsTable = void 0;
const collections_1 = require("../Lib/collections");
const model_1 = require("../Lib/Model/model");
const termsAndConditionsCollection = (conn) => conn.connection.collection(collections_1.Collection.TermsAndConditions);
const prepareTermsAndConditionsTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield termsAndConditionsCollection(conn).createIndex('uid', {
        name: 'uid',
        unique: true,
        background: true,
    });
});
exports.prepareTermsAndConditionsTable = prepareTermsAndConditionsTable;
const createTermsAndConditionsModel = (conn) => (Object.assign({}, (0, model_1.createModel)({
    conn,
    collection: collections_1.Collection.TermsAndConditions,
})));
exports.createTermsAndConditionsModel = createTermsAndConditionsModel;
//# sourceMappingURL=termsAndConditionsModel.js.map