"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createTermsAgreementModel = exports.prepareTermsExceptionTable = exports.prepareTermsAgreementTable = void 0;
const bson_1 = require("bson");
const collections_1 = require("../Lib/collections");
const termsAgreementCollection = (conn) => conn.connection.collection(collections_1.Collection.TermsAgreement);
const termsExceptionCollection = (conn) => conn.connection.collection(collections_1.Collection.TermsException);
const prepareTermsAgreementTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield termsAgreementCollection(conn).createIndex('termsVersion', { name: 'termsVersion', background: true });
    yield termsAgreementCollection(conn).createIndex('accountId', { name: 'accountId', background: true });
});
exports.prepareTermsAgreementTable = prepareTermsAgreementTable;
const prepareTermsExceptionTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield termsExceptionCollection(conn).createIndex('termsVersion', { name: 'termsVersion', background: true });
});
exports.prepareTermsExceptionTable = prepareTermsExceptionTable;
const createTermsAgreementModel = (conn) => ({
    fetchByAccountId(accountId) {
        return __awaiter(this, void 0, void 0, function* () {
            const termsAgreement = yield termsAgreementCollection(conn).findOne({ accountId }, { session: conn.session });
            return termsAgreement;
        });
    },
    hasAgreedWithTerms(accountId, termsVersion, termsAndConditionsUid) {
        return __awaiter(this, void 0, void 0, function* () {
            const agreement = yield termsAgreementCollection(conn).findOne({ accountId, termsVersion, termsAndConditionsUid }, { session: conn.session });
            return agreement !== null;
        });
    },
    shouldAgreeWithTerms(accountId, termsVersion, termsAndConditionsUid) {
        return __awaiter(this, void 0, void 0, function* () {
            const termsException = yield termsExceptionCollection(conn).findOne({ accountId, termsVersion, termsAndConditionsUid }, { session: conn.session });
            return termsException === null;
        });
    },
    markTermsAgreed(termsAgreement) {
        return __awaiter(this, void 0, void 0, function* () {
            const agreement = Object.assign({ _id: new bson_1.ObjectId() }, termsAgreement);
            yield termsAgreementCollection(conn).insertOne(agreement, { session: conn.session });
        });
    },
});
exports.createTermsAgreementModel = createTermsAgreementModel;
//# sourceMappingURL=termsModel.js.map