"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createPackageVersionNoteModel = exports.preparePackageVersionNoteTable = void 0;
const bson_1 = require("bson");
const collections_1 = require("../Lib/collections");
const packageVersionNoteCollection = (conn) => conn.connection.collection(collections_1.Collection.PackageVersionNote);
const preparePackageVersionNoteTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield packageVersionNoteCollection(conn).createIndex('uid', { name: 'uid', unique: true, background: true });
    yield packageVersionNoteCollection(conn).createIndex('packageVersionUid', { name: 'packageVersionUid', background: true });
});
exports.preparePackageVersionNoteTable = preparePackageVersionNoteTable;
const createPackageVersionNoteModel = (conn) => ({
    create(uid, packageVersionUid, noteText, createdAt, createdByAccountId) {
        return __awaiter(this, void 0, void 0, function* () {
            const id = new bson_1.ObjectId();
            const pkgVersionNote = {
                _id: id,
                uid,
                packageVersionUid,
                noteText,
                createdAt,
                createdByAccountId,
            };
            yield packageVersionNoteCollection(conn).insertOne(pkgVersionNote, { session: conn.session });
        });
    },
    fetchByUid(uid) {
        return __awaiter(this, void 0, void 0, function* () {
            return packageVersionNoteCollection(conn).findOne({
                uid,
                deletedAt: null,
            }, { session: conn.session });
        });
    },
    fetchListByPackageVersionUid(packageVersionUid) {
        return __awaiter(this, void 0, void 0, function* () {
            return packageVersionNoteCollection(conn)
                .find({
                packageVersionUid,
                deletedAt: null,
            }, { session: conn.session })
                .toArray();
        });
    },
    delete(packageVersionNote, deletedAt) {
        return __awaiter(this, void 0, void 0, function* () {
            yield packageVersionNoteCollection(conn).updateOne({ uid: packageVersionNote.uid }, { $set: { deletedAt } }, { session: conn.session });
        });
    },
});
exports.createPackageVersionNoteModel = createPackageVersionNoteModel;
//# sourceMappingURL=packageVersionNoteModel.js.map