"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createPackageVersionModel = exports.preparePackageVersionTable = void 0;
const bson_1 = require("bson");
const appletVersionModel_1 = require("../Applet/appletVersionModel");
const versions_1 = require("../../Helpers/versions");
const utils_1 = require("../Lib/utils");
const pagination_1 = require("../Lib/Pagination/pagination");
const collections_1 = require("../Lib/collections");
const ICursor_1 = require("../../Cursor/ICursor");
const packageVersionCollection = (conn) => conn.connection.collection(collections_1.Collection.PackageVersion);
const preparePackageVersionTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield packageVersionCollection(conn).createIndex('uid', { name: 'uid', unique: true, background: true });
    yield packageVersionCollection(conn).createIndex('releasedAt', { name: 'releasedAt', background: true });
    yield packageVersionCollection(conn).createIndex('publishedSince', { name: 'publishedSince', background: true });
    yield (0, appletVersionModel_1.appletVersionCollection)(conn).createIndex({
        packageName: 1,
        applicationType: 1,
        version: 1,
        build: 1,
    }, { name: 'packageName_applicationType_version_build', background: true });
});
exports.preparePackageVersionTable = preparePackageVersionTable;
const createPackageVersionModel = (conn) => ({
    update(uid, updateObject) {
        return __awaiter(this, void 0, void 0, function* () {
            yield packageVersionCollection(conn).updateOne({ uid }, { $set: Object.assign({}, updateObject) }, { session: conn.session });
        });
    },
    create(uid, packageRow, applicationType, buildHash, version, build, iconUrl, createdAt, createdByAccountId, specs) {
        return __awaiter(this, void 0, void 0, function* () {
            const id = new bson_1.ObjectId();
            const pkgVersion = {
                _id: id,
                uid,
                packageName: packageRow.packageName,
                applicationType: applicationType,
                buildHash,
                version,
                build,
                iconUrl,
                createdAt,
                releasedAt: createdAt,
                createdByAccountId,
                specs,
            };
            yield packageVersionCollection(conn).insertOne(pkgVersion, { session: conn.session });
        });
    },
    getPackageVersionIterator() {
        const cursor = packageVersionCollection(conn).find({}, { session: conn.session });
        return (0, ICursor_1.cursorIterator)(cursor);
    },
    fetchListByPackageAndApplicationType(packageEntity, applicationType) {
        return packageVersionCollection(conn)
            .find({
            packageName: packageEntity.packageName,
            applicationType,
        }, { session: conn.session })
            .toArray();
    },
    fetchListByPackageListAndApplicationType(packages, applicationType) {
        const packageNames = packages.map((pkg) => pkg.packageName);
        return packageVersionCollection(conn)
            .find({
            packageName: {
                $in: packageNames,
            },
            applicationType,
        }, { session: conn.session })
            .toArray();
    },
    fetchListByPackageNames(packageNames) {
        return packageVersionCollection(conn)
            .find({
            packageName: {
                $in: packageNames,
            },
            deletedAt: { $exists: false },
        }, { session: conn.session })
            .toArray();
    },
    fetchByUid(uid) {
        return __awaiter(this, void 0, void 0, function* () {
            return packageVersionCollection(conn).findOne({
                uid,
                deletedAt: { $exists: false },
            }, { session: conn.session });
        });
    },
    fetchByPackageNameAndApplicationAndVersionAndBuild(packageName, applicationType, version, build) {
        return __awaiter(this, void 0, void 0, function* () {
            return packageVersionCollection(conn).findOne({
                packageName,
                applicationType,
                version,
                build,
                deletedAt: { $exists: false },
            }, { session: conn.session });
        });
    },
    fetchListByUids(uids) {
        return __awaiter(this, void 0, void 0, function* () {
            return packageVersionCollection(conn)
                .find({
                uid: { $in: uids },
                deletedAt: { $exists: false },
            }, { session: conn.session })
                .toArray();
        });
    },
    fetchList(params = {}) {
        var _a, _b;
        return __awaiter(this, void 0, void 0, function* () {
            const { filter, pagination, sort } = params;
            const packageNameFilter = (filter === null || filter === void 0 ? void 0 : filter.packageName) ? { packageName: filter === null || filter === void 0 ? void 0 : filter.packageName } : {};
            const deletedAtFilter = { deletedAt: { $exists: false } };
            const matcher = Object.assign(Object.assign({}, packageNameFilter), deletedAtFilter);
            const sortWithDefault = {
                field: (_a = sort === null || sort === void 0 ? void 0 : sort.field) !== null && _a !== void 0 ? _a : 'createdAt',
                order: (_b = sort === null || sort === void 0 ? void 0 : sort.order) !== null && _b !== void 0 ? _b : 'descending',
            };
            const { sorter, paginator } = (0, pagination_1.createSorterWithPaginator)({
                sort: sortWithDefault,
                pagination,
                since: filter === null || filter === void 0 ? void 0 : filter.createdSince,
                until: filter === null || filter === void 0 ? void 0 : filter.createdUntil,
            });
            const pipeline = (0, utils_1.getPipelineLegacy)({
                matcher,
                sorter,
                paginator,
            });
            let aggregationCursor = packageVersionCollection(conn).aggregate(pipeline, {
                session: conn.session,
            });
            const paginatedAggregationCursor = (0, pagination_1.getPaginatedAggregationCursor)({
                aggregationCursor,
                pagination,
            });
            const packages = yield paginatedAggregationCursor.toArray();
            return packages;
        });
    },
    fetchListByPackageNameVersion(packageNameVersionTuples) {
        return __awaiter(this, void 0, void 0, function* () {
            const filterQueries = packageNameVersionTuples.map((pkgNameVersionTuple) => {
                const query = {
                    $and: [{ packageName: pkgNameVersionTuple[0] }, { version: pkgNameVersionTuple[1] }, { deletedAt: { $exists: false } }],
                };
                return query;
            });
            const filter = {
                $or: filterQueries,
            };
            return packageVersionCollection(conn).find(filter, { session: conn.session }).toArray();
        });
    },
    fetchListByApplication(applicationType, onlyPublished) {
        return __awaiter(this, void 0, void 0, function* () {
            const filter = { applicationType, deletedAt: { $exists: false } };
            if (onlyPublished) {
                filter.publishedSince = { $exists: true };
            }
            return packageVersionCollection(conn).find(filter, { session: conn.session }).toArray();
        });
    },
    fetchByPackageNameAndApplicationTypeAndBuildHash(packageName, applicationType, buildHash) {
        return __awaiter(this, void 0, void 0, function* () {
            return packageVersionCollection(conn).findOne({
                packageName,
                applicationType,
                buildHash,
            }, { session: conn.session });
        });
    },
    delete(packageVersion, deletedAt) {
        return __awaiter(this, void 0, void 0, function* () {
            yield packageVersionCollection(conn).updateOne({ uid: packageVersion.uid }, { $set: { deletedAt } }, { session: conn.session });
        });
    },
    fetchDeleted() {
        return __awaiter(this, void 0, void 0, function* () {
            return packageVersionCollection(conn)
                .find({ deletedAt: { $exists: true } }, { session: conn.session })
                .toArray();
        });
    },
    markAsPublished(packageVersionRow, publishedSince) {
        return __awaiter(this, void 0, void 0, function* () {
            yield packageVersionCollection(conn).updateOne({ uid: packageVersionRow.uid }, { $set: { publishedSince } }, { session: conn.session });
        });
    },
    markAsNotPublished(packageVersionRow) {
        return __awaiter(this, void 0, void 0, function* () {
            yield packageVersionCollection(conn).updateOne({ uid: packageVersionRow.uid }, { $unset: { publishedSince: '' } }, { session: conn.session });
        });
    },
    /**
     * @param onlyReleased it is the not tagged semver `version`: 3.0.0, 5.2.1 (not 2.3.1-master.123 etc)
     */
    fetchLatestByApplication(applicationType, packageName, onlyReleased, onlyPublished) {
        return __awaiter(this, void 0, void 0, function* () {
            const filter = {
                applicationType,
                packageName,
            };
            if (onlyPublished) {
                filter.publishedSince = { $exists: true };
            }
            if (onlyReleased) {
                filter.version = { $not: RegExp(/-/, 'gi') };
            }
            const found = yield packageVersionCollection(conn)
                .find(filter, { session: conn.session })
                .toArray();
            found.sort(versions_1.semverComparatorDesc);
            return found.length >= 1 ? found[0] : null;
        });
    },
});
exports.createPackageVersionModel = createPackageVersionModel;
//# sourceMappingURL=packageVersionModel.js.map