"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createOrganizationStatisticsModel = exports.prepareOrganizationStatisticsTable = void 0;
const organizationStatisticsModel_1 = require("../../Schema/Organization/organizationStatisticsModel");
const collections_1 = require("../Lib/collections");
const organizationStatisticsCollection = (conn) => conn.connection.collection(collections_1.Collection.OrganizationStatistics);
const prepareOrganizationStatisticsTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield organizationStatisticsCollection(conn).createIndex('organizationUid', { name: 'organizationUid', background: true });
    yield organizationStatisticsCollection(conn).createIndex('scope', { name: 'scope', background: true });
    yield organizationStatisticsCollection(conn).createIndex('year', { name: 'year', background: true });
    yield organizationStatisticsCollection(conn).createIndex('month', { name: 'month', background: true });
    yield organizationStatisticsCollection(conn).createIndex('day', { name: 'day', background: true });
    yield organizationStatisticsCollection(conn).createIndex({
        organizationUid: 1,
        scope: 1,
        year: 1,
        month: 1,
        day: 1,
    }, { name: 'compoundSnapshot', background: true });
});
exports.prepareOrganizationStatisticsTable = prepareOrganizationStatisticsTable;
const createOrganizationStatisticsModel = (conn) => ({
    createDeviceSnapshot({ organizationUid, scope, totalDevices, newDevices, deprovisionedDevices, year, month, day, }) {
        return __awaiter(this, void 0, void 0, function* () {
            validateScope(scope, year, month, day);
            const snapshot = {
                organizationUid,
                scope,
                year,
                month,
                day,
                devices: {
                    total: totalDevices,
                    new: newDevices,
                    deprovisioned: deprovisionedDevices,
                },
            };
            yield organizationStatisticsCollection(conn).replaceOne({ organizationUid, scope, year, month, day }, snapshot, {
                session: conn.session,
                upsert: true,
            });
        });
    },
    getOrganizationDeviceStatisticsSnapshot(organizationUid, scope, year, month, day) {
        return __awaiter(this, void 0, void 0, function* () {
            validateScope(scope, year, month, day);
            const filter = Object.assign(Object.assign({}, getScopeFilter(scope, year, month, day)), { organizationUid });
            return organizationStatisticsCollection(conn).findOne(filter, { session: conn.session });
        });
    },
    getOrganizationDeviceStatisticsSnapshots(organizationUid, scope, since, until) {
        return __awaiter(this, void 0, void 0, function* () {
            let dateFromParts = { year: '$year' };
            if (scope === organizationStatisticsModel_1.OrganizationStatisticScope.Month) {
                dateFromParts = Object.assign(Object.assign({}, dateFromParts), { month: { $toInt: '$month' } });
            }
            if (scope === organizationStatisticsModel_1.OrganizationStatisticScope.Day) {
                dateFromParts = Object.assign(Object.assign({}, dateFromParts), { month: { $toInt: '$month' }, day: { $toInt: '$day' } });
            }
            return organizationStatisticsCollection(conn)
                .aggregate([
                {
                    $match: {
                        organizationUid,
                        scope,
                    },
                },
                {
                    $addFields: {
                        date: {
                            $dateFromParts: dateFromParts,
                        },
                    },
                },
                {
                    $match: {
                        date: {
                            $gte: since,
                            $lte: until,
                        },
                    },
                },
            ])
                .toArray();
        });
    },
    getOrganizationsDeviceStatisticsSnapshots(organizationUids, scope, since, until) {
        return __awaiter(this, void 0, void 0, function* () {
            let dateFromParts = { year: '$year' };
            if (scope === organizationStatisticsModel_1.OrganizationStatisticScope.Month) {
                dateFromParts = Object.assign(Object.assign({}, dateFromParts), { month: { $toInt: '$month' } });
            }
            if (scope === organizationStatisticsModel_1.OrganizationStatisticScope.Day) {
                dateFromParts = Object.assign(Object.assign({}, dateFromParts), { month: { $toInt: '$month' }, day: { $toInt: '$day' } });
            }
            const aggregationResult = yield organizationStatisticsCollection(conn)
                .aggregate([
                {
                    $match: {
                        organizationUid: { $in: organizationUids },
                        scope,
                    },
                },
                {
                    $addFields: {
                        date: {
                            $dateFromParts: dateFromParts,
                        },
                    },
                },
                {
                    $match: {
                        date: {
                            $gte: since,
                            $lte: until,
                        },
                    },
                },
            ])
                .toArray();
            return aggregationResult.reduce((acc, c) => {
                var _a;
                return Object.assign(Object.assign({}, acc), { [c.organizationUid]: [...((_a = acc[c.organizationUid]) !== null && _a !== void 0 ? _a : []), c] });
            }, {});
        });
    },
});
exports.createOrganizationStatisticsModel = createOrganizationStatisticsModel;
function validateScope(scope, year, month, day) {
    if (scope === organizationStatisticsModel_1.OrganizationStatisticScope.Year) {
        if (!year) {
            throw new Error('Requested `year` scope, but invalid year value provided.');
        }
    }
    if (scope === organizationStatisticsModel_1.OrganizationStatisticScope.Month) {
        if (!month) {
            throw new Error('Requested `month` scope, but no month value provided.');
        }
    }
    if (scope === organizationStatisticsModel_1.OrganizationStatisticScope.Day) {
        if (!month) {
            throw new Error('Requested `day` scope, but no month value provided.');
        }
        if (!day) {
            throw new Error('Requested `day` scope, but no day value provided.');
        }
    }
}
function getScopeFilter(scope, year, month, day) {
    let filter = { scope };
    if (scope === organizationStatisticsModel_1.OrganizationStatisticScope.Year) {
        filter = Object.assign(Object.assign({}, filter), { year });
    }
    if (scope === organizationStatisticsModel_1.OrganizationStatisticScope.Month) {
        filter = Object.assign(Object.assign({}, filter), { year, month });
    }
    if (scope === organizationStatisticsModel_1.OrganizationStatisticScope.Day) {
        filter = Object.assign(Object.assign({}, filter), { year, month, day });
    }
    return filter;
}
//# sourceMappingURL=organizationStatisticsModel.js.map