"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createOrganizationDetailsModel = exports.prepareOrganizationDetailsTable = void 0;
const collections_1 = require("../Lib/collections");
const organizationDetailsCollection = (conn) => conn.connection.collection(collections_1.Collection.OrganizationDetails);
const prepareOrganizationDetailsTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield organizationDetailsCollection(conn).createIndex('organizationUid', { name: 'organizationUid', unique: true, background: true });
});
exports.prepareOrganizationDetailsTable = prepareOrganizationDetailsTable;
const createOrganizationDetailsModel = (conn) => ({
    create(organizationUid) {
        return __awaiter(this, void 0, void 0, function* () {
            const orgDetails = { organizationUid };
            yield organizationDetailsCollection(conn).insertOne(orgDetails, { session: conn.session });
        });
    },
    fetchByOrganizationUid(organizationUid) {
        return organizationDetailsCollection(conn).findOne({ organizationUid }, { session: conn.session });
    },
    fetchListByOrganizationUids(organizationUids) {
        return organizationDetailsCollection(conn)
            .find({ organizationUid: { $in: organizationUids } }, { session: conn.session })
            .toArray();
    },
    updateDeviceStatistics(organizationUid, devicesCountAll, devicesCountWeek, devicesCountMonth, devicesCountLastMonth) {
        return __awaiter(this, void 0, void 0, function* () {
            yield organizationDetailsCollection(conn).updateOne({ organizationUid }, {
                $set: {
                    devicesCountAll,
                    devicesCountWeek,
                    devicesCountMonth,
                    devicesCountLastMonth,
                },
            }, { session: conn.session });
        });
    },
});
exports.createOrganizationDetailsModel = createOrganizationDetailsModel;
//# sourceMappingURL=organizationDetailsModel.js.map