"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createPipelineFromFilter = void 0;
const lodash_1 = require("lodash");
const organizationTagModel_1 = require("../../../Schema/Organization/Tag/organizationTagModel");
const createPipelineFromFilter = (filter) => {
    const pipeline = [
        {
            $match: Object.assign(Object.assign(Object.assign(Object.assign(Object.assign({}, ((filter === null || filter === void 0 ? void 0 : filter.uids)
                ? {
                    uid: {
                        $in: filter.uids,
                    },
                }
                : {})), ((filter === null || filter === void 0 ? void 0 : filter.organizationUids)
                ? {
                    organizationUid: {
                        $in: filter === null || filter === void 0 ? void 0 : filter.organizationUids,
                    },
                }
                : {})), ((filter === null || filter === void 0 ? void 0 : filter.search)
                ? {
                    name: { $regex: (0, lodash_1.escapeRegExp)(filter.search), $options: 'i' },
                }
                : {})), ((filter === null || filter === void 0 ? void 0 : filter.color)
                ? {
                    color: filter.color,
                }
                : {})), ((filter === null || filter === void 0 ? void 0 : filter.rootTag)
                ? {
                    parentTagUid: filter.rootTag ? null : { $ne: null },
                }
                : {})),
        },
        {
            $lookup: {
                from: 'device',
                foreignField: 'tagUids',
                localField: 'uid',
                as: 'devices',
            },
        },
        {
            $lookup: {
                from: 'location',
                foreignField: 'tagUids',
                localField: 'uid',
                as: 'locations',
            },
        },
        {
            $addFields: {
                devicesCount: { $size: '$devices' },
                locationsCount: { $size: '$locations' },
            },
        },
    ];
    if (filter.assignedTo && filter.assignedTo.length > 0) {
        pipeline.push({
            $match: {
                $or: [
                    filter.assignedTo.includes(organizationTagModel_1.TagAssignedTo.DEVICE)
                        ? {
                            devicesCount: { $gt: 0 },
                        }
                        : {},
                    filter.assignedTo.includes(organizationTagModel_1.TagAssignedTo.LOCATION)
                        ? {
                            locationsCount: { $gt: 0 },
                        }
                        : {},
                    filter.assignedTo.includes(organizationTagModel_1.TagAssignedTo.NOT_ASSIGNED)
                        ? {
                            devicesCount: { $eq: 0 },
                            locationsCount: { $eq: 0 },
                        }
                        : {},
                ].filter((value) => Object.keys(value).length !== 0),
            },
        });
    }
    if (filter.includeChildren) {
        pipeline.push({
            $graphLookup: {
                from: 'organizationTag',
                startWith: '$uid',
                connectFromField: 'uid',
                connectToField: 'parentTagUid',
                depthField: 'depth',
                as: 'children',
            },
        });
    }
    return pipeline;
};
exports.createPipelineFromFilter = createPipelineFromFilter;
//# sourceMappingURL=organizationTagModelUtils.js.map