"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createOrganizationTagModel = exports.prepareOrganizationTagTable = exports.organizationTagCollection = void 0;
const collections_1 = require("../../Lib/collections");
const model_1 = require("../../Lib/Model/model");
const organizationTagModelUtils_1 = require("./organizationTagModelUtils");
const paginationTypes_1 = require("../../../Lib/Pagination/paginationTypes");
const organizationTagCollection = (conn) => conn.connection.collection(collections_1.Collection.OrganizationTag);
exports.organizationTagCollection = organizationTagCollection;
const prepareOrganizationTagTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield (0, exports.organizationTagCollection)(conn).createIndex({ uid: 1 }, { name: 'uid', unique: true, background: true });
    yield (0, exports.organizationTagCollection)(conn).createIndex({ organizationUid: 1 }, { name: 'organizationUid', unique: false, background: true });
    yield (0, exports.organizationTagCollection)(conn).createIndex({ name: 1 }, { name: 'name', unique: false, background: true });
    yield (0, exports.organizationTagCollection)(conn).createIndex({ createdAt: -1 }, { name: 'createdAt', unique: false, background: true });
    yield (0, exports.organizationTagCollection)(conn).createIndex({ uid: 1, name: 1 }, { name: 'uid_name', unique: false, background: true });
    /*
    TODO: uncomment when data on amy is fixed
    await organizationTagCollection(conn).createIndex(
        { organizationUid: 1, name: 1 },
        { name: 'organizationUid_name', unique: true, background: true },
    );
    */
});
exports.prepareOrganizationTagTable = prepareOrganizationTagTable;
const createOrganizationTagModel = (conn) => (Object.assign(Object.assign({}, (0, model_1.createModel)({
    conn,
    collection: collections_1.Collection.OrganizationTag,
})), { fetchListByPropertyFilter(props) {
        var _a, _b, _c;
        return __awaiter(this, void 0, void 0, function* () {
            const pipeline = (0, organizationTagModelUtils_1.createPipelineFromFilter)((_a = props.filter) !== null && _a !== void 0 ? _a : {});
            if (props.sort) {
                pipeline.push({ $sort: { [props.sort.field]: props.sort.order === paginationTypes_1.SortOrder.DESC ? -1 : 1 } });
            }
            if ((_b = props.pagination) === null || _b === void 0 ? void 0 : _b.offset) {
                pipeline.push({ $skip: props.pagination.offset });
            }
            if ((_c = props.pagination) === null || _c === void 0 ? void 0 : _c.limit) {
                pipeline.push({ $limit: props.pagination.limit });
            }
            return yield (0, exports.organizationTagCollection)(conn).aggregate(pipeline, { session: conn.session }).toArray();
        });
    },
    fetchOrganizationTagChildrenTreeUids(tagUid) {
        return __awaiter(this, void 0, void 0, function* () {
            const pipeline = [
                {
                    $match: {
                        uid: tagUid,
                    },
                },
                {
                    $graphLookup: {
                        from: 'organizationTag',
                        startWith: '$uid',
                        connectFromField: 'uid',
                        connectToField: 'parentTagUid',
                        depthField: 'depth',
                        as: 'children',
                    },
                },
            ];
            const tagsWithChildren = yield (0, exports.organizationTagCollection)(conn).aggregate(pipeline, { session: conn.session }).toArray();
            const tagWithChildren = tagsWithChildren[0];
            const tags = [tagWithChildren.uid];
            for (const tag of tagWithChildren.children) {
                tags.push(tag.uid);
            }
            return tags;
        });
    },
    fetchUniqueColors(filter) {
        return __awaiter(this, void 0, void 0, function* () {
            const pipeline = (0, organizationTagModelUtils_1.createPipelineFromFilter)(filter);
            pipeline.push({ $group: { _id: '$color' } });
            pipeline.push({ $match: { _id: { $ne: null } } });
            pipeline.push({ $sort: { _id: 1 } });
            const result = yield (0, exports.organizationTagCollection)(conn).aggregate(pipeline, { session: conn.session }).toArray();
            return result.map((row) => row._id);
        });
    },
    countByPropertyFilter(filter) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const pipeline = (0, organizationTagModelUtils_1.createPipelineFromFilter)(filter);
            pipeline.push({ $count: 'count' });
            const [result] = yield (0, exports.organizationTagCollection)(conn).aggregate(pipeline, { session: conn.session }).toArray();
            return (_a = result === null || result === void 0 ? void 0 : result.count) !== null && _a !== void 0 ? _a : 0;
        });
    },
    fetchListByOrganizationUid(organizationUid) {
        const query = (0, exports.organizationTagCollection)(conn).find({
            organizationUid,
        });
        return query.sort({ name: 1 }).toArray();
    },
    fetchListByOrganizationUids(organizationUids) {
        const query = (0, exports.organizationTagCollection)(conn).find({
            organizationUid: {
                $in: organizationUids,
            },
        });
        return query.toArray();
    },
    fetchCountByOrganizationUids(organizationUids) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const [result] = yield (0, exports.organizationTagCollection)(conn)
                .aggregate([
                {
                    $match: {
                        organizationUid: {
                            $in: organizationUids,
                        },
                    },
                },
                { $count: 'count' },
            ], { session: conn.session })
                .toArray();
            return (_a = result === null || result === void 0 ? void 0 : result.count) !== null && _a !== void 0 ? _a : 0;
        });
    },
    fetchByNameAndOrganizationUid(organizationUid, name) {
        return (0, exports.organizationTagCollection)(conn).findOne({
            organizationUid,
            name,
        }, { session: conn.session });
    },
    fetchListByUidList(uidList) {
        const query = (0, exports.organizationTagCollection)(conn).find({
            uid: {
                $in: uidList,
            },
        });
        return query.sort({ name: 1 }).toArray();
    },
    fetchListByOrganizationUidAndPropertyFilter(organizationUid, pagination) {
        const pipeline = [{ $match: { organizationUid } }];
        if (pagination === null || pagination === void 0 ? void 0 : pagination.since) {
            pipeline.push({ $match: { createdAt: { $gte: pagination.since } } });
        }
        if (pagination === null || pagination === void 0 ? void 0 : pagination.until) {
            pipeline.push({ $match: { createdAt: { $lt: pagination.until } } });
        }
        if ((pagination === null || pagination === void 0 ? void 0 : pagination.descending) === true) {
            pipeline.push({ $sort: { [pagination.sortKey]: -1 } });
        }
        else {
            pipeline.push({ $sort: { [pagination.sortKey]: 1 } });
        }
        if (pagination === null || pagination === void 0 ? void 0 : pagination.limit) {
            pipeline.push({ $limit: pagination.limit });
        }
        return (0, exports.organizationTagCollection)(conn).aggregate(pipeline, { session: conn.session }).toArray();
    } }));
exports.createOrganizationTagModel = createOrganizationTagModel;
//# sourceMappingURL=organizationTagModel.js.map