"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __asyncValues = (this && this.__asyncValues) || function (o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createLocationModel = exports.prepareLocationTable = exports.locationCollection = void 0;
const locationModel_1 = require("../../Schema/Location/locationModel");
const deviceModel_1 = require("../Device/deviceModel");
const paginatorHelper_1 = require("../../MongoDB/paginatorHelper");
const collections_1 = require("../Lib/collections");
const locationModelUtils_1 = require("./locationModelUtils");
const utils_1 = require("../Lib/utils");
const ICursor_1 = require("../../Cursor/ICursor");
const model_1 = require("../Lib/Model/model");
const locationCollection = (conn) => conn.connection.collection(collections_1.Collection.Location);
exports.locationCollection = locationCollection;
const prepareLocationTable = (connection) => __awaiter(void 0, void 0, void 0, function* () {
    yield (0, exports.locationCollection)(connection).createIndex({ uid: 1 }, { name: 'uid', unique: true, background: true });
    yield (0, exports.locationCollection)(connection).createIndex({ organizationUid: 1 }, { name: 'organizationUid', background: true });
    yield (0, exports.locationCollection)(connection).createIndex({ name: 1 }, { name: 'name', background: true });
    yield (0, exports.locationCollection)(connection).createIndex({ tagUids: 1 }, { name: 'tagUids', background: true });
    yield (0, exports.locationCollection)(connection).createIndex({ customId: 1 }, { name: 'customId', background: true });
    yield (0, exports.locationCollection)(connection).createIndex({ 'feature.geometry': '2dsphere' }, { name: 'feature_dot_geometry', background: true });
    yield (0, exports.locationCollection)(connection).createIndex({ 'feature.properties.context.id': 1, 'feature.properties.context.text': 1 }, { name: 'feature.properties.context', background: true });
});
exports.prepareLocationTable = prepareLocationTable;
const createLocationModel = (connection) => {
    function isWithDeviceNumber(location, withDeviceNumber) {
        return withDeviceNumber === true && location !== null;
    }
    return Object.assign(Object.assign({}, (0, model_1.createModel)({ conn: connection, collection: collections_1.Collection.Location })), { archive(locationRow, archivedAt) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.locationCollection)(connection).updateOne({ uid: locationRow.uid }, {
                    $set: {
                        updatedAt: archivedAt,
                        archivedAt,
                    },
                }, { session: connection.session });
            });
        },
        unarchive(locationRow, unarchivatedAt) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.locationCollection)(connection).updateOne({ uid: locationRow.uid }, { $set: { updatedAt: unarchivatedAt }, $unset: { archivedAt: '' } }, { session: connection.session });
            });
        },
        fetchByUid(uid, withDeviceNumber) {
            return __awaiter(this, void 0, void 0, function* () {
                const location = yield (0, exports.locationCollection)(connection).findOne({ uid }, { session: connection.session });
                if (isWithDeviceNumber(location, withDeviceNumber)) {
                    location.deviceNumber = yield (0, deviceModel_1.deviceCollection)(connection).countDocuments({
                        locationUid: location.uid,
                    });
                }
                return location;
            });
        },
        fetchByUids(uids, status = locationModel_1.LocationStatus.ACTIVE) {
            return __awaiter(this, void 0, void 0, function* () {
                const sorting = (0, utils_1.getSorting)({});
                const filterMatch = (0, locationModelUtils_1.getMatcherFromPropertyFilter)({ status });
                const matcher = Object.assign(Object.assign({}, filterMatch), { uid: { $in: uids } });
                const pipeline = (0, utils_1.getPipeline)({ matcher, sorting });
                return (0, exports.locationCollection)(connection).aggregate(pipeline, { session: connection.session }).toArray();
            });
        },
        fetchListByOrganizations(organizations, pagination, status = locationModel_1.LocationStatus.ACTIVE) {
            return __awaiter(this, void 0, void 0, function* () {
                const organizationUids = organizations.map((organization) => organization.uid);
                const filter = { organizationUids };
                const paginationAndSorting = (0, paginatorHelper_1.mapIPaginatorToPaginationAndSorting)(pagination);
                return yield this.fetchListByPropertyFilterV2({ filter, paginationAndSorting, status });
            });
        },
        fetchListByPropertyFilter(filter, withDeviceNumber, pagination, status = locationModel_1.LocationStatus.ACTIVE) {
            return __awaiter(this, void 0, void 0, function* () {
                const paginationAndSorting = (0, paginatorHelper_1.mapIPaginatorToPaginationAndSorting)(pagination);
                const sorting = (0, utils_1.getSorting)({ sorting: paginationAndSorting === null || paginationAndSorting === void 0 ? void 0 : paginationAndSorting.sorting });
                const matcher = (0, locationModelUtils_1.getMatcherFromPropertyFilter)({ filter, status });
                let pipeline = (0, utils_1.getPipeline)({ matcher, pagination, sorting });
                if (withDeviceNumber) {
                    pipeline = (0, locationModelUtils_1.getWithDeviceNumberPipeline)(pipeline);
                }
                const result = yield (0, exports.locationCollection)(connection).aggregate(pipeline, { session: connection.session }).toArray();
                return result;
            });
        },
        fetchListByPropertyFilterV2({ filter, paginationAndSorting, status = locationModel_1.LocationStatus.ACTIVE, }) {
            return __awaiter(this, void 0, void 0, function* () {
                const sorting = (0, utils_1.getSorting)({ sorting: paginationAndSorting === null || paginationAndSorting === void 0 ? void 0 : paginationAndSorting.sorting });
                const matcher = (0, locationModelUtils_1.getMatcherFromPropertyFilter)({ filter, status });
                const pipeline = (0, utils_1.getPipeline)({ matcher, pagination: paginationAndSorting === null || paginationAndSorting === void 0 ? void 0 : paginationAndSorting.pagination, sorting });
                return (0, exports.locationCollection)(connection).aggregate(pipeline, { session: connection.session }).toArray();
            });
        },
        fetchTotalCountByPropertyFilter(filter, status = locationModel_1.LocationStatus.ACTIVE) {
            var _a;
            return __awaiter(this, void 0, void 0, function* () {
                const sorting = (0, utils_1.getSorting)({});
                const matcher = (0, locationModelUtils_1.getMatcherFromPropertyFilter)({ filter, status });
                const pipeline = (0, utils_1.getPipeline)({ matcher, sorting });
                pipeline.push({ $count: 'count' });
                const [result] = yield (0, exports.locationCollection)(connection).aggregate(pipeline, { session: connection.session }).toArray();
                return (_a = result === null || result === void 0 ? void 0 : result.count) !== null && _a !== void 0 ? _a : 0;
            });
        },
        fetchPropertyValuesByPropertyFilter({ filter, propertyKey, status = locationModel_1.LocationStatus.ACTIVE, }) {
            var e_1, _a;
            return __awaiter(this, void 0, void 0, function* () {
                const matcher = (0, locationModelUtils_1.getMatcherFromPropertyFilter)({ filter, status });
                const pipeline = (0, locationModelUtils_1.getPropertyValuesPipeline)({ matcher, propertyKey });
                const properyValuesCursor = (0, exports.locationCollection)(connection).aggregate(pipeline, { session: connection.session });
                const result = [];
                try {
                    for (var _b = __asyncValues((0, ICursor_1.cursorIterator)(properyValuesCursor)), _c; _c = yield _b.next(), !_c.done;) {
                        const value = _c.value;
                        if (value) {
                            result.push(value._id);
                        }
                    }
                }
                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return)) yield _a.call(_b);
                    }
                    finally { if (e_1) throw e_1.error; }
                }
                return result;
            });
        },
        fetchPropertyValuesCountByPropertyFilter({ filter, propertyKey, status = locationModel_1.LocationStatus.ACTIVE, }) {
            var _a;
            return __awaiter(this, void 0, void 0, function* () {
                const matcher = (0, locationModelUtils_1.getMatcherFromPropertyFilter)({ filter, status });
                const pipeline = (0, locationModelUtils_1.getPropertyValuesPipeline)({ matcher, propertyKey });
                const [result] = yield (0, exports.locationCollection)(connection)
                    .aggregate([...pipeline, { $count: 'count' }], {
                    session: connection.session,
                })
                    .toArray();
                return result ? (_a = result.count) !== null && _a !== void 0 ? _a : 0 : 0;
            });
        },
        assignTag(locationRow, organizationTagRow) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.locationCollection)(connection).updateOne({ uid: locationRow.uid }, { $addToSet: { tagUids: organizationTagRow.uid } }, { session: connection.session });
            });
        },
        removeTag(locationRow, organizationTagRow) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.locationCollection)(connection).updateOne({ uid: locationRow.uid }, { $pull: { tagUids: organizationTagRow.uid } }, { session: connection.session });
            });
        } });
};
exports.createLocationModel = createLocationModel;
//# sourceMappingURL=locationModel.js.map