"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createOwnServerLicenseValidityModel = exports.prepareOwnServerLicenseValidityTable = void 0;
const bson_1 = require("bson");
const collections_1 = require("../Lib/collections");
const ownServerLicenseValidityCollection = (conn) => conn.connection.collection(collections_1.Collection.OwnServerLicenseValidity);
const prepareOwnServerLicenseValidityTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield ownServerLicenseValidityCollection(conn).createIndex('id', { name: 'id', unique: true, background: true });
    yield ownServerLicenseValidityCollection(conn).createIndex('expireAt', { name: 'expireAt', background: true });
});
exports.prepareOwnServerLicenseValidityTable = prepareOwnServerLicenseValidityTable;
const createOwnServerLicenseValidityModel = (conn) => ({
    create(ownServerLicense, createdAt, expireAt, license, signature) {
        return __awaiter(this, void 0, void 0, function* () {
            const id = new bson_1.ObjectId();
            const licenseValidity = {
                _id: id,
                id: id.toHexString(),
                ownServerLicenseId: ownServerLicense.id,
                createdAt,
                expireAt,
                license,
                signature,
            };
            yield ownServerLicenseValidityCollection(conn).insertOne(licenseValidity, { session: conn.session });
        });
    },
    fetchValidList(now) {
        return __awaiter(this, void 0, void 0, function* () {
            return ownServerLicenseValidityCollection(conn)
                .find({ expireAt: { $gt: now } }, { session: conn.session })
                .sort({ expireAt: -1 })
                .toArray();
        });
    },
    fetchLastByOwnLicense(ownServerLicense) {
        return __awaiter(this, void 0, void 0, function* () {
            return ownServerLicenseValidityCollection(conn).findOne({
                ownServerLicenseId: ownServerLicense.id,
            }, {
                session: conn.session,
                sort: { expireAt: -1 },
            });
        });
    },
});
exports.createOwnServerLicenseValidityModel = createOwnServerLicenseValidityModel;
//# sourceMappingURL=ownServerLicenseValidityModel.js.map