"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createIssuedServerLicenseModel = exports.prepareIssuedServerLicenseTable = void 0;
const bson_1 = require("bson");
const collections_1 = require("../Lib/collections");
const issuedServerLicenseCollection = (conn) => conn.connection.collection(collections_1.Collection.IssuedServerLicense);
const prepareIssuedServerLicenseTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield issuedServerLicenseCollection(conn).createIndex('id', { name: 'id', unique: true, background: true });
    yield issuedServerLicenseCollection(conn).createIndex('licenseKey', { name: 'licenseKey', unique: true, background: true });
});
exports.prepareIssuedServerLicenseTable = prepareIssuedServerLicenseTable;
const createIssuedServerLicenseModel = (conn) => ({
    create(licenseKey, organization, createdAt) {
        return __awaiter(this, void 0, void 0, function* () {
            const id = new bson_1.ObjectId();
            const license = {
                _id: id,
                id: id.toHexString(),
                licenseKey,
                licenseSecret: null,
                organizationUid: organization.uid,
                createdAt,
            };
            yield issuedServerLicenseCollection(conn).insertOne(license, { session: conn.session });
        });
    },
    fetchByLicenseKey(licenseKey) {
        return __awaiter(this, void 0, void 0, function* () {
            return issuedServerLicenseCollection(conn).findOne({ licenseKey }, { session: conn.session });
        });
    },
    fetchListByOrganizationUid(organizationUid) {
        return __awaiter(this, void 0, void 0, function* () {
            return issuedServerLicenseCollection(conn).find({ organizationUid }, { session: conn.session }).toArray();
        });
    },
    fetchByOrganizationAndLicenseKey(organization, licenseKey) {
        return __awaiter(this, void 0, void 0, function* () {
            return issuedServerLicenseCollection(conn).findOne({
                organizationUid: organization.uid,
                licenseKey,
            }, { session: conn.session });
        });
    },
    setLicenseSecret(issuedServerLicenseRow, licenseSecret) {
        return __awaiter(this, void 0, void 0, function* () {
            yield issuedServerLicenseCollection(conn).updateOne({ id: issuedServerLicenseRow.id }, { $set: { licenseSecret } }, { session: conn.session });
        });
    },
});
exports.createIssuedServerLicenseModel = createIssuedServerLicenseModel;
//# sourceMappingURL=issuedServerLicenseModel.js.map