"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createIssuedDeviceLicenseModel = exports.prepareIssuedDeviceLicenseTable = void 0;
const bson_1 = require("bson");
const collections_1 = require("../Lib/collections");
const issuedDeviceLicenseCollection = (conn) => conn.connection.collection(collections_1.Collection.IssuedDeviceLicense);
const prepareIssuedDeviceLicenseTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield issuedDeviceLicenseCollection(conn).createIndex('id', { name: 'id', unique: true, background: true });
    yield issuedDeviceLicenseCollection(conn).createIndex('duid', { name: 'duid', background: true });
});
exports.prepareIssuedDeviceLicenseTable = prepareIssuedDeviceLicenseTable;
const createIssuedDeviceLicenseModel = (conn) => ({
    create(duid, application, createdAt, sourceIssuedServerLicenseValidity, subscriptionType) {
        return __awaiter(this, void 0, void 0, function* () {
            const license = {
                id: new bson_1.ObjectId().toHexString(),
                duid,
                applicationType: application.type,
                createdAt,
                sourceIssuedServerLicenseValidityId: sourceIssuedServerLicenseValidity ? sourceIssuedServerLicenseValidity.id : null,
                subscriptionType,
            };
            yield issuedDeviceLicenseCollection(conn).insertOne(license, { session: conn.session });
        });
    },
    fetchListByOrganizationCreatedBetween(organization, createdSince, createdUntil) {
        return __awaiter(this, void 0, void 0, function* () {
            const pipeline = [];
            // Lookup
            pipeline.push({
                $lookup: {
                    from: collections_1.Collection.IssuedServerLicenseValidity,
                    localField: 'sourceIssuedServerLicenseValidityId',
                    foreignField: 'id',
                    as: 'sourceIssuedServerLicenseValidity',
                },
            });
            pipeline.push({
                $lookup: {
                    from: collections_1.Collection.IssuedServerLicense,
                    localField: 'sourceIssuedServerLicenseValidity.issuedServerLicenseId',
                    foreignField: 'id',
                    as: 'sourceIssuedServerLicenseValidity.issuedServerLicense',
                },
            });
            // Filter
            const match = {
                ['sourceIssuedServerLicenseValidity.issuedServerLicense.organizationUid']: organization.uid,
            };
            if (createdSince || createdUntil) {
                match.createdAt = {};
                if (createdSince) {
                    match.createdAt.$gte = createdSince;
                }
                if (createdUntil) {
                    match.createdAt.$lte = createdUntil;
                }
            }
            pipeline.push({ $match: match });
            // Remove extra lookup fields
            pipeline.push({
                $project: {
                    id: 1,
                    duid: 1,
                    applicationType: 1,
                    createdAt: 1,
                    sourceIssuedServerLicenseValidityId: 1,
                    subscriptionType: 1,
                },
            });
            return issuedDeviceLicenseCollection(conn).aggregate(pipeline, { session: conn.session }).toArray();
        });
    },
});
exports.createIssuedDeviceLicenseModel = createIssuedDeviceLicenseModel;
//# sourceMappingURL=issuedDeviceLicenseModel.js.map