"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPipelineLegacy = exports.getSorting = exports.getPipelinePartsFromPaginationAndSorting = exports.getPipeline = void 0;
const lodash_1 = require("lodash");
const paginationTypes_1 = require("../../Lib/Pagination/paginationTypes");
const pagination_1 = require("../../Lib/Pagination/pagination");
function getPipeline({ matcher, pagination, sorting }) {
    let match = matcher !== null && matcher !== void 0 ? matcher : null;
    const { offset, limit, paginationMatch, sort } = getPipelinePartsFromPaginationAndSorting({ pagination, sorting });
    const pipeline = [];
    if (match !== null || paginationMatch !== null) {
        pipeline.push({
            $match: Object.assign(Object.assign({}, (match !== null && match !== void 0 ? match : {})), (paginationMatch !== null && paginationMatch !== void 0 ? paginationMatch : {})),
        });
    }
    pipeline.push(sort);
    if (offset !== null) {
        pipeline.push(offset);
    }
    if (limit !== null) {
        pipeline.push(limit);
    }
    return pipeline;
}
exports.getPipeline = getPipeline;
function getPipelinePartsFromPaginationAndSorting({ pagination, sorting, }) {
    let offset = null;
    let limit = null;
    let paginationMatch = null;
    const sort = getSorter(sorting);
    if (pagination !== undefined) {
        if (pagination.limit !== undefined) {
            limit = limitToPipeline(pagination.limit);
        }
        if ((0, paginationTypes_1.isOffsetPagination)(pagination)) {
            offset = offsetPaginationToPipeline(pagination);
        }
        else if ((0, paginationTypes_1.isLinkPagination)(pagination)) {
            paginationMatch = linkPaginationToMatcher(sorting, pagination);
        }
    }
    return { offset, limit, paginationMatch, sort };
}
exports.getPipelinePartsFromPaginationAndSorting = getPipelinePartsFromPaginationAndSorting;
function getSorting({ sorting, mapSortingField, }) {
    return (0, pagination_1.getSorting)({
        defaultSorting: {
            field: 'createdAt',
            order: paginationTypes_1.SortOrder.DESC,
        },
        sorting: sorting
            ? {
                field: mapSortingField ? mapSortingField(sorting.field) : sorting.field,
                order: sorting.order,
            }
            : undefined,
    });
}
exports.getSorting = getSorting;
function limitToPipeline(limit) {
    return { $limit: limit };
}
function offsetPaginationToPipeline(pagination) {
    if (pagination.offset !== undefined) {
        return { $skip: pagination.offset };
    }
    return null;
}
function linkPaginationToMatcher(sorting, pagination) {
    const matcher = {};
    if (pagination.since && pagination.until) {
        matcher[sorting.field] = { $gte: pagination.since, $lt: pagination.until };
    }
    else if (pagination.since) {
        matcher[sorting.field] = { $gte: pagination.since };
    }
    else if (pagination.until) {
        matcher[sorting.field] = { $lt: pagination.until };
    }
    return matcher;
}
function getSorter(sorting) {
    const sortingOrder = sorting.order === paginationTypes_1.SortOrder.ASC ? 1 : -1;
    return {
        $sort: {
            [sorting.field]: sortingOrder,
        },
    };
}
/** @deprecated use getPipeline */
const getPipelineLegacy = ({ matcher, sorter, paginator, }) => {
    const pipeline = [{ $match: (0, lodash_1.merge)(matcher, paginator !== null && paginator !== void 0 ? paginator : {}) }, sorter !== null && sorter !== void 0 ? sorter : {}];
    return pipeline.filter((a) => (Object.keys(a).length !== 0 ? true : false));
};
exports.getPipelineLegacy = getPipelineLegacy;
//# sourceMappingURL=utils.js.map