import { Pagination, RequiredSorting, Sorting } from '../../Lib/Pagination/paginationTypes';
export interface GetPipelineParams {
    sorting: RequiredSorting<string>;
    matcher?: object;
    pagination?: Pagination;
}
export declare function getPipeline({ matcher, pagination, sorting }: GetPipelineParams): object[];
export declare function getPipelinePartsFromPaginationAndSorting({ pagination, sorting, }: {
    pagination?: Pagination;
    sorting: RequiredSorting<string>;
}): {
    offset: object | null;
    limit: object | null;
    paginationMatch: object | null;
    sort: {
        $sort: {
            [x: string]: number;
        };
    };
};
export declare function getSorting<TSortField extends string>({ sorting, mapSortingField, }: {
    sorting?: Sorting<TSortField>;
    mapSortingField?: (field: TSortField) => string;
}): Required<Sorting<string>>;
interface IGetPipelineLegacyParams<Matcher, Sorter, Paginator> {
    matcher: Matcher;
    sorter?: Sorter;
    paginator?: Paginator;
}
/** @deprecated use getPipeline */
export declare const getPipelineLegacy: <Matcher, Sorter, Paginator>({ matcher, sorter, paginator, }: IGetPipelineLegacyParams<Matcher, Sorter, Paginator>) => ({
    $match: Matcher & {};
} | {
    $match?: undefined;
})[];
export {};
//# sourceMappingURL=utils.d.ts.map