export declare type ProjectConfig<F extends string> = {
    [K in F]?: 0 | 1;
};
/**
 * It merges two project configs into a single one.
 * It prevents combining $project to contain both 0 and 1 values.
 * It doesn't make sense to have both, since ones are explicit includes and zeros are explicit excludes.
 *
 * E.g.:
 *
 * { name: 1, model: 1 } + { name: 0, firmwareVersion: 1 } = { model: 1, firmwareVersion: 1 }
 * The name field is removed, because it's both included and excluded. If the `name: 0` is kept, then MongoDB query would fail.
 *
 * However, when all project configs has only zeros, then the zeros are kept (it will use only excluding fields from the result).
 * { name: 0, model: 0 } + { firmwareVersion: 0 } = { name: 0, model: 0, firmwareVersion: 0 }
 */
export declare function mergeProjectConfigs<F1 extends string, F2 extends string>(projectConfig1: ProjectConfig<F1> | undefined, projectConfig2: ProjectConfig<F2> | undefined): ProjectConfig<F1 | F2> | undefined;
//# sourceMappingURL=mergeProjectConfigs.d.ts.map