"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createFirmwareVersionModel = exports.prepareFirmwareVersionTable = void 0;
const bson_1 = require("bson");
const appletVersionModel_1 = require("../Applet/appletVersionModel");
const collections_1 = require("../Lib/collections");
const firmwareVersionCollection = (conn) => conn.connection.collection(collections_1.Collection.FirmwareVersion);
const prepareFirmwareVersionTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield firmwareVersionCollection(conn).createIndex('uid', { name: 'uid', unique: true, background: true });
    yield firmwareVersionCollection(conn).createIndex('releasedAt', { name: 'releasedAt', background: true });
    yield (0, appletVersionModel_1.appletVersionCollection)(conn).createIndex({
        applicationType: 1,
        version: 1,
    }, { name: 'applicationType_version', background: true });
    yield (0, appletVersionModel_1.appletVersionCollection)(conn).createIndex({
        applicationType: 1,
        version: 1,
        type: 1,
    }, { name: 'applicationType_version_type', background: true });
});
exports.prepareFirmwareVersionTable = prepareFirmwareVersionTable;
const createFirmwareVersionModel = (conn) => ({
    create(application, version, createdAt, type) {
        return __awaiter(this, void 0, void 0, function* () {
            const id = new bson_1.ObjectId();
            const fwVersion = {
                _id: id,
                uid: id.toHexString(),
                applicationType: application.type,
                version,
                type,
                createdAt,
            };
            yield firmwareVersionCollection(conn).insertOne(fwVersion, { session: conn.session });
        });
    },
    fetchByUid(uid) {
        return __awaiter(this, void 0, void 0, function* () {
            return firmwareVersionCollection(conn).findOne({ uid }, { session: conn.session });
        });
    },
    fetchByApplicationAndVersion(application, version, type) {
        return __awaiter(this, void 0, void 0, function* () {
            return firmwareVersionCollection(conn).findOne({
                applicationType: application.type,
                version,
                type: type !== null && type !== void 0 ? type : null,
            }, { session: conn.session });
        });
    },
    fetchListByUids(uids) {
        return __awaiter(this, void 0, void 0, function* () {
            return firmwareVersionCollection(conn)
                .find({ uid: { $in: uids } }, { session: conn.session })
                .toArray();
        });
    },
    fetchList(onlyReleased) {
        return __awaiter(this, void 0, void 0, function* () {
            let query = {};
            if (onlyReleased) {
                query = { releasedAt: { $exists: true } };
            }
            return firmwareVersionCollection(conn).find(query, { session: conn.session }).toArray();
        });
    },
});
exports.createFirmwareVersionModel = createFirmwareVersionModel;
//# sourceMappingURL=firmwareVersionModel.js.map