"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDomainModel = exports.prepareDomainTable = exports.domainCollection = void 0;
const Debug = require("debug");
const datetime_1 = require("../../MongoDB/datetime");
const collections_1 = require("../Lib/collections");
const debug = Debug('@signageos/user-domain-model:Mongo:EventSourcing:domainModel');
const domainCollection = (conn) => conn.connection.collection(collections_1.Collection.Domain);
exports.domainCollection = domainCollection;
const prepareDomainTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield (0, exports.domainCollection)(conn).createIndex('name', { name: 'name', unique: true });
});
exports.prepareDomainTable = prepareDomainTable;
const createDomainModel = (conn) => ({
    fetchByName(name) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield (0, exports.domainCollection)(conn).findOne({ name }, { session: conn.session });
        });
    },
    create(name, event) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.domainCollection)(conn).insertOne({ name, lastEventReceivedAt: event.receivedAt, lastEventSecondaryIndex: event.secondaryIndex }, { session: conn.session });
        });
    },
    update(name, event) {
        return __awaiter(this, void 0, void 0, function* () {
            const result = yield (0, exports.domainCollection)(conn).updateOne({ name }, { $set: { lastEventReceivedAt: event.receivedAt, lastEventSecondaryIndex: event.secondaryIndex } }, { session: conn.session });
            if (result.matchedCount === 0) {
                throw new Error(`Domain ${name} was not found`);
            }
        });
    },
    observeByName(name) {
        return __awaiter(this, void 0, void 0, function* () {
            const currentTimestamp = yield (0, datetime_1.getCurrentTimestamp)(conn.connection.db);
            const pipelineItem = {
                $match: {
                    'fullDocument.name': name,
                    operationType: { $in: ['insert', 'replace', 'update'] },
                },
            };
            const watchOptions = {
                fullDocument: 'updateLookup',
                startAtOperationTime: currentTimestamp,
            };
            return new Observable((observer) => {
                const changeStream = (0, exports.domainCollection)(conn).watch([pipelineItem], watchOptions);
                const onChange = (value) => {
                    observer.next(value.fullDocument);
                };
                changeStream.on('change', onChange);
                return () => __awaiter(this, void 0, void 0, function* () {
                    changeStream.removeListener('change', onChange);
                    try {
                        yield changeStream.close();
                        debug(`Observable subscription closed`);
                    }
                    catch (error) {
                        observer.error(error);
                    }
                });
            });
        });
    },
});
exports.createDomainModel = createDomainModel;
//# sourceMappingURL=domainModel.js.map