"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createConsumedEventModel = exports.prepareConsumedEventTable = exports.consumedEventCollection = void 0;
const collections_1 = require("../Lib/collections");
const consumedEventCollection = (conn) => conn.connection.collection(collections_1.Collection.ConsumedEvent);
exports.consumedEventCollection = consumedEventCollection;
const prepareConsumedEventTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield (0, exports.consumedEventCollection)(conn).createIndex({ domainName: 1, eventId: 1 }, // TODO maybe not domainName
    { name: 'domainName_eventId', unique: true });
    yield (0, exports.consumedEventCollection)(conn).createIndex({ consumedAt: 1 }, { name: 'consumedAt', background: true });
});
exports.prepareConsumedEventTable = prepareConsumedEventTable;
const createConsumedEventModel = (conn) => ({
    create(domainName, eventId, eventType, consumedAt) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.consumedEventCollection)(conn).insertOne({ domainName, eventId, eventType, consumedAt }, { session: conn.session });
        });
    },
    fetchByDomainNameAndEventId(domainName, eventId) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield (0, exports.consumedEventCollection)(conn).findOne({ domainName, eventId }, { session: conn.session });
        });
    },
});
exports.createConsumedEventModel = createConsumedEventModel;
//# sourceMappingURL=consumedEventModel.js.map