"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.convertPropertyFilterToMongoFilter = exports.getDeprovisionedDeviceSorting = exports.getFetchListByOrganizationsProjection = exports.createPipelineFromPropertyFilter = exports.createPipelineSorterFromPropertySorter = void 0;
const pagination_1 = require("../../Lib/Pagination/pagination");
const paginationTypes_1 = require("../../Lib/Pagination/paginationTypes");
const mergeProjectConfigs_1 = require("../Lib/Aggregate/mergeProjectConfigs");
const mongodb_1 = require("mongodb");
const object_1 = require("@signageos/lib/dist/Utils/object");
const lodash_1 = require("lodash");
const createPipelineSorterFromPropertySorter = (pipeline, propertySorter) => {
    const sortDirection = propertySorter.direction === 'descending' ? -1 : 1;
    switch (propertySorter.field) {
        case 'applicationType':
            pipeline.push({ $sort: { applicationType: sortDirection } });
            break;
        case 'name':
            pipeline.push({ $sort: { nameLowerCase: sortDirection } });
            break;
        case 'model':
            pipeline.push({ $sort: { model: sortDirection } });
            break;
        case 'firmwareVersion':
            pipeline.push({ $sort: { firmwareVersion: sortDirection } });
            break;
        case 'firmwareType':
            pipeline.push({ $sort: { firmwareType: sortDirection } });
            break;
        case 'serialNumber':
            pipeline.push({ $sort: { serialNumber: sortDirection } });
            break;
        case 'createdAt':
            pipeline.push({ $sort: { createdAt: sortDirection } });
            break;
        default:
            throw new Error('Unknown property to sort by.');
    }
};
exports.createPipelineSorterFromPropertySorter = createPipelineSorterFromPropertySorter;
function getProjectConfig(fields = []) {
    return fields.reduce((project, field) => (Object.assign(Object.assign({}, project), { [field]: 1 })), {});
}
function createPipelineFromPropertyFilter(propertyFilter) {
    let projection = undefined;
    const pipeline = [];
    if (propertyFilter.search) {
        pipeline.push({
            $lookup: {
                from: 'deviceVerification',
                foreignField: 'deviceIdentityHash',
                localField: 'identityHash',
                as: 'deviceVerification',
            },
        }, { $unwind: '$deviceVerification' });
        projection = { $project: { deviceVerification: 0 } };
    }
    if (propertyFilter.appletUids) {
        pipeline.push({
            $lookup: {
                from: 'timing',
                localField: 'identityHash',
                foreignField: 'deviceIdentityHash',
                as: 'timing',
            },
        }, {
            $addFields: {
                appletUids: {
                    $map: {
                        input: '$timing',
                        as: 'applets',
                        in: '$$applets.appletUid',
                    },
                },
            },
        }, {
            $project: { timing: 0 },
        });
        const mergedProjectConfigs = (0, mergeProjectConfigs_1.mergeProjectConfigs)(projection === null || projection === void 0 ? void 0 : projection.$project, { appletUids: 0 });
        projection = { $project: mergedProjectConfigs };
    }
    return { pipeline, projection };
}
exports.createPipelineFromPropertyFilter = createPipelineFromPropertyFilter;
const getFetchListByOrganizationsProjection = ({ filter, fields, }) => {
    let { pipeline, projection } = createPipelineFromPropertyFilter(filter);
    const finalProjection = {
        $project: (0, mergeProjectConfigs_1.mergeProjectConfigs)(fields ? Object.assign({ _id: 0, uid: 1, organizationUid: 1 }, getProjectConfig(fields)) : undefined, projection === null || projection === void 0 ? void 0 : projection.$project),
    };
    return { pipeline, projection: finalProjection.$project ? finalProjection : undefined };
};
exports.getFetchListByOrganizationsProjection = getFetchListByOrganizationsProjection;
const getDeprovisionedDeviceSorting = (sorting) => {
    return (0, pagination_1.getSorting)({
        defaultSorting: {
            field: 'lastDeprovisionAt',
            order: paginationTypes_1.SortOrder.DESC,
        },
        sorting,
    });
};
exports.getDeprovisionedDeviceSorting = getDeprovisionedDeviceSorting;
const mergeIdentityHashes = (mongoFilter, deviceIdentityHashes) => {
    if (mongoFilter.identityHash) {
        if (isStringLikeCondition(mongoFilter.identityHash)) {
            return (0, lodash_1.intersection)(deviceIdentityHashes, [mongoFilter.identityHash]);
        }
        else if (mongoFilter.identityHash.$in) {
            return (0, lodash_1.intersection)(deviceIdentityHashes, mongoFilter.identityHash.$in);
        }
    }
    return deviceIdentityHashes;
};
function convertPropertyFilterToMongoFilter({ sourceMongoFilter, propertyFilter, deviceInfoModel, }) {
    return __awaiter(this, void 0, void 0, function* () {
        return (0, object_1.getObjectKeys)(propertyFilter)
            .filter((key) => !(0, lodash_1.isUndefined)(propertyFilter[key]))
            .reduce((mongoFilterPromise, key) => __awaiter(this, void 0, void 0, function* () {
            var _a, _b, _c;
            const mongoFilter = yield mongoFilterPromise;
            const mergeWithFilter = (filterExtension) => (0, lodash_1.merge)(mongoFilter, filterExtension);
            const mergeAndFilter = (filterExtension) => {
                var _a;
                let andArray = (_a = mongoFilter.$and) !== null && _a !== void 0 ? _a : [];
                if (Array.isArray(filterExtension)) {
                    filterExtension.forEach((extension) => {
                        andArray.push(extension);
                    });
                }
                else {
                    andArray.push(filterExtension);
                }
                const and = { $and: andArray };
                return mergeWithFilter(and);
            };
            switch (key) {
                case 'identityHash':
                    return mergeWithFilter({ identityHash: { $eq: propertyFilter[key] } });
                case 'identityHashes':
                    const identityHashes = mergeIdentityHashes(mongoFilter, (_a = propertyFilter[key]) !== null && _a !== void 0 ? _a : []);
                    return Object.assign(Object.assign({}, mongoFilter), { identityHash: { $in: identityHashes } });
                case 'identityHashesExclude':
                    return mergeWithFilter({ identityHash: { $nin: propertyFilter[key] } });
                case 'uids':
                    return mergeWithFilter({ uid: { $in: propertyFilter[key] } });
                case 'uidsExclude':
                    return mergeWithFilter({ uid: { $nin: propertyFilter[key] } });
                case 'accountId':
                    return mergeWithFilter({ accountId: { $eq: propertyFilter[key] } });
                case 'model':
                    return mergeWithFilter({ model: { $eq: propertyFilter[key] } });
                case 'brands':
                    return mergeWithFilter({ brand: { $in: propertyFilter[key] } });
                case 'firmwareVersion':
                    return mergeWithFilter({ firmwareVersion: { $eq: propertyFilter[key] } });
                case 'firmwareType':
                    return mergeWithFilter({ firmwareType: { $eq: propertyFilter[key] } });
                case 'organizationUid':
                    return mergeWithFilter({ organizationUid: { $eq: propertyFilter[key] } });
                case 'applicationType':
                    return mergeWithFilter({ applicationType: { $eq: propertyFilter[key] } });
                case 'applicationTypes':
                    return mergeWithFilter({ applicationType: { $in: propertyFilter[key] } });
                case 'applicationTypeNotEqual':
                    return mergeWithFilter({ applicationType: { $ne: propertyFilter[key] } });
                case 'search':
                    const searchStartsRegexp = new RegExp(`^${propertyFilter[key]}`, 'i');
                    const searchFullTextRegexp = new RegExp(`${propertyFilter[key]}`, 'i');
                    if (!deviceInfoModel) {
                        throw new Error(`The filtering by ${String(key)} is not supported because it requires the deviceInfoModel`);
                    }
                    const deviceInfoListHashes = yield deviceInfoModel.fetchIdentityHashesByPropertyFilter({
                        ethernetMacAddress: searchStartsRegexp,
                        ethernetIpAddress: searchStartsRegexp,
                        wifiIpAddress: searchStartsRegexp,
                        wifiMacAddress: searchStartsRegexp,
                    });
                    return mergeAndFilter({
                        $or: [
                            { uid: searchStartsRegexp },
                            { identityHash: searchStartsRegexp },
                            { name: searchFullTextRegexp },
                            { serialNumber: searchStartsRegexp },
                            { 'deviceVerification.hash': searchStartsRegexp },
                            { identityHash: { $in: deviceInfoListHashes } },
                        ],
                    });
                case 'serialNumber':
                    return mergeWithFilter({ serialNumber: { $eq: propertyFilter[key] } });
                case 'bannedSince':
                    return mergeWithFilter({ bannedSince: { $gte: propertyFilter[key] } });
                case 'createdSince':
                    return mergeWithFilter({ createdAt: { $gte: propertyFilter[key] } });
                case 'createdUntil':
                    return mergeWithFilter({ createdAt: { $lt: propertyFilter[key] } });
                case 'maxStorageStatusPercentage':
                case 'minStorageStatusPercentage':
                    if (!deviceInfoModel) {
                        throw new Error(`The filtering by ${String(key)} is not supported because it requires the deviceInfoModel`);
                    }
                    let deviceIdentityHashes = yield deviceInfoModel.fetchIdentityHashesByStorageStatus(key, propertyFilter[key]);
                    deviceIdentityHashes = mergeIdentityHashes(mongoFilter, deviceIdentityHashes);
                    return Object.assign(Object.assign({}, mongoFilter), { identityHash: { $in: deviceIdentityHashes } });
                case 'tagUids':
                    return Array.isArray(propertyFilter[key]) && propertyFilter[key].length > 0
                        ? mergeWithFilter({
                            tagUids: {
                                $all: propertyFilter[key],
                            },
                        })
                        : mergeWithFilter({
                            tagUids: {
                                $exists: false,
                            },
                        });
                case 'policyUids':
                    return mergeWithFilter({
                        'policies.uid': Array.isArray(propertyFilter[key]) ? { $in: propertyFilter[key] } : propertyFilter[key],
                    });
                case 'locationUids':
                    return mergeWithFilter({
                        locationUid: { $in: propertyFilter[key] },
                    });
                case 'filterModelName':
                    return mergeWithFilter({
                        model: new RegExp((_c = (_b = propertyFilter[key]) === null || _b === void 0 ? void 0 : _b.toString()) !== null && _c !== void 0 ? _c : '', 'i'),
                    });
                case 'appletUids': {
                    const filterValue = propertyFilter[key];
                    if (Array.isArray(filterValue) && filterValue.length === 0) {
                        return mergeWithFilter({
                            appletUids: { $size: 0 },
                        });
                    }
                    else {
                        return mergeWithFilter({ appletUids: { $in: filterValue } });
                    }
                }
                case 'osVersions': {
                    return mergeWithFilter({
                        osVersion: { $in: propertyFilter[key] },
                    });
                }
                case 'tagWithChildrenUidGroups': {
                    const filterArray = [];
                    for (const value of propertyFilter[key]) {
                        filterArray.push({
                            tagUids: {
                                $in: value,
                            },
                        });
                    }
                    return mergeAndFilter(filterArray);
                }
                case 'orFilter': {
                    let queryToMerge = {};
                    const filterValue = propertyFilter[key];
                    if (isOrFilter(filterValue)) {
                        const partialMongoFilter = yield convertPropertyFilterToMongoFilter({
                            sourceMongoFilter: {},
                            propertyFilter: filterValue,
                            deviceInfoModel,
                        });
                        // Convert partial filter to array of expressions
                        const expressions = Object.entries(partialMongoFilter).map(([expressionKey, expressionValue]) => ({
                            [expressionKey]: expressionValue,
                        }));
                        queryToMerge = { $or: expressions };
                    }
                    return mergeAndFilter(queryToMerge);
                }
                case 'hasPolicy': {
                    if (propertyFilter[key] === true) {
                        return mergeWithFilter({
                            policies: { $exists: true, $ne: null, $not: { $size: 0 } },
                        });
                    }
                    if (propertyFilter[key] === false) {
                        return mergeWithFilter({
                            $or: [{ policies: { $exists: false } }, { policies: { $eq: null } }, { policies: { $size: 0 } }],
                        });
                    }
                }
                default:
                    throw new Error('Unknown property filter key');
            }
        }), Promise.resolve(sourceMongoFilter));
    });
}
exports.convertPropertyFilterToMongoFilter = convertPropertyFilterToMongoFilter;
const OrFilterKeys = [
    'tagUids',
    'tagWithChildrenUidGroups',
    'locationUids',
];
function isStringLikeCondition(value) {
    return typeof value === 'string' || value instanceof RegExp || value instanceof mongodb_1.BSONRegExp;
}
function isOrFilter(filterValue) {
    return (typeof filterValue !== undefined &&
        typeof filterValue === 'object' &&
        filterValue !== null &&
        Object.keys(filterValue).every((key) => OrFilterKeys.includes(key)));
}
//# sourceMappingURL=deviceModel.utils.js.map