import { DeviceFilter } from '@signageos/common-types/dist/Device/deviceFilter';
import { Sorting } from '../../Lib/Pagination/paginationTypes';
import { ProjectConfig } from '../Lib/Aggregate/mergeProjectConfigs';
import { FieldSorterType, IDevice, IDevicePropertySorter } from '../../Schema/Device/deviceModel';
import { Filter } from 'mongodb';
import { IDeviceInfoModelRead } from '../../Schema/Device/Info/deviceInfoModel';
interface IGetFetchListByOrganizationsProjectionParams<F> {
    filter: DeviceFilter;
    fields?: F[];
}
export declare const createPipelineSorterFromPropertySorter: (pipeline: object[], propertySorter: IDevicePropertySorter) => void;
export declare function createPipelineFromPropertyFilter(propertyFilter: DeviceFilter): {
    pipeline: object[];
    projection: {
        $project: ProjectConfig<'deviceVerification' | 'timing'>;
    } | undefined;
};
export declare const getFetchListByOrganizationsProjection: <F extends string>({ filter, fields, }: IGetFetchListByOrganizationsProjectionParams<F>) => {
    pipeline: object[];
    projection: {
        $project: ProjectConfig<"uid" | "organizationUid" | "_id" | "deviceVerification" | "timing" | F> | undefined;
    } | undefined;
};
export declare const getDeprovisionedDeviceSorting: (sorting?: Sorting<FieldSorterType>) => Required<Sorting<FieldSorterType>>;
export declare function convertPropertyFilterToMongoFilter({ sourceMongoFilter, propertyFilter, deviceInfoModel, }: {
    sourceMongoFilter: Filter<IDevice>;
    propertyFilter: DeviceFilter;
    deviceInfoModel: IDeviceInfoModelRead | undefined;
}): Promise<Filter<IDevice>>;
export {};
//# sourceMappingURL=deviceModel.utils.d.ts.map