"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createStatisticsDeprovisionedFilter = exports.createStatisticsProvisionedFilter = exports.createDeviceModel = exports.prepareDeviceTable = exports.organizationCollection = exports.deviceCollection = void 0;
const organizationModel_1 = require("../../Schema/Organization/organizationModel");
const paginationTypes_1 = require("../../Lib/Pagination/paginationTypes");
const organization_utils_1 = require("../Organization/organization.utils");
const organizationModel_2 = require("../Organization/organizationModel");
const ICursor_1 = require("../../Cursor/ICursor");
const deviceModel_utils_1 = require("./deviceModel.utils");
const utils_1 = require("../Lib/utils");
const collections_1 = require("../Lib/collections");
const pagination_1 = require("../../Lib/Pagination/pagination");
const deviceModel_utils_2 = require("../Device/deviceModel.utils");
const deviceCollection = (conn) => conn.connection.collection(collections_1.DeviceCollection.Device);
exports.deviceCollection = deviceCollection;
const organizationCollection = (conn) => conn.connection.collection(collections_1.Collection.Organization);
exports.organizationCollection = organizationCollection;
const prepareDeviceTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield (0, exports.deviceCollection)(conn).createIndex({ uid: 1 }, { name: 'uid', unique: true, background: true });
    yield (0, exports.deviceCollection)(conn).createIndex({ identityHash: 1 }, { name: 'identityHash', unique: true, background: true });
    yield (0, exports.deviceCollection)(conn).createIndex({ createdAt: 1 }, { name: 'createdAt', background: true });
    yield (0, exports.deviceCollection)(conn).createIndex({ name: 1 }, { name: 'name', background: true });
    yield (0, exports.deviceCollection)(conn).createIndex({ nameLowerCase: 1 }, { name: 'nameLowerCase', background: true });
    yield (0, exports.deviceCollection)(conn).createIndex({ model: 1 }, { name: 'model', background: true });
    yield (0, exports.deviceCollection)(conn).createIndex({ serialNumber: 1 }, { name: 'serialNumber', background: true });
    yield (0, exports.deviceCollection)(conn).createIndex({ applicationType: 1 }, { name: 'applicationType', background: true });
    yield (0, exports.deviceCollection)(conn).createIndex({ organizationUid: 1 }, { name: 'organizationUid', background: true });
    yield (0, exports.deviceCollection)(conn).createIndex({ lastOrganizationUid: 1 }, { name: 'lastOrganizationUid', background: true });
    yield (0, exports.deviceCollection)(conn).createIndex({ lastOrganizationUid: 1, lastDeprovisionAt: 1 }, { name: 'lastOrganizationUid_lastDeprovisionAt', background: true });
    yield (0, exports.deviceCollection)(conn).createIndex({ accountId: 1 }, { name: 'accountId', background: true });
    yield (0, exports.deviceCollection)(conn).createIndex({ createdAt: -1, identityHash: 1 }, { name: 'createdAt_identityHash', unique: true, background: true });
    yield (0, exports.deviceCollection)(conn).createIndex({ createdAt: -1, name: 1 }, { name: 'createdAt_name', background: true });
    yield (0, exports.deviceCollection)(conn).createIndex({ createdAt: -1, nameLowerCase: 1 }, { name: 'createdAt_nameLowerCase', background: true });
    yield (0, exports.deviceCollection)(conn).createIndex({ createdAt: -1, model: 1 }, { name: 'createdAt_model', background: true });
    yield (0, exports.deviceCollection)(conn).createIndex({ createdAt: -1, serialNumber: 1 }, { name: 'createdAt_serialNumber', background: true });
    yield (0, exports.deviceCollection)(conn).createIndex({ createdAt: -1, applicationType: 1 }, { name: 'createdAt_applicationType', background: true });
    yield (0, exports.deviceCollection)(conn).createIndex({ createdAt: -1, organizationUid: 1 }, { name: 'createdAt_organizationUid', background: true });
    yield (0, exports.deviceCollection)(conn).createIndex({ createdAt: -1, accountId: 1 }, { name: 'createdAt_accountId', background: true });
    yield (0, exports.deviceCollection)(conn).createIndex({ lastProvisionedAt: 1 }, { name: 'lastProvisionedAt', background: true });
    yield (0, exports.deviceCollection)(conn).createIndex({ lastDeprovisionedAt: 1 }, { name: 'lastDeprovisionedAt', background: true });
    yield (0, exports.deviceCollection)(conn).createIndex({ firmwareType: 1 }, { name: 'firmwareType', background: true });
    yield (0, exports.deviceCollection)(conn).createIndex({ firmwareVersion: 1 }, { name: 'firmwareVersion', background: true });
    yield (0, exports.deviceCollection)(conn).createIndex({ bannedSince: 1 }, { name: 'bannedSince', background: true });
    yield (0, exports.deviceCollection)(conn).createIndex({ tagUids: 1 }, { name: 'tagUids', background: true });
    yield (0, exports.deviceCollection)(conn).createIndex({ extendedManagementSince: 1 }, { name: 'extendedManagementSince', background: true });
    yield (0, exports.deviceCollection)(conn).createIndex({ 'policies.uid': 1 }, { name: 'policies_dot_uid', background: true });
    yield (0, exports.deviceCollection)(conn).createIndex({ locationUid: 1 }, { name: 'locationUid', partialFilterExpression: { locationUid: { $exists: true } }, background: true });
});
exports.prepareDeviceTable = prepareDeviceTable;
/**
 * The second spread parameter ...extraModels is optional.
 * But if it's empty, you cannot use some features of filtering like search, maxStorageStatusPercentage, minStorageStatusPercentage.
 * Use the following TypeScript construction in you application if you are using deviceModel with DeviceFilter:
 * ```ts
 * import {
 * 	IDevice,
 * 	IDeviceModelRead as IDeviceModelReadOriginal,
 * } from '@signageos/user-domain-model/dist/Schema/Device/deviceModel';
 * import { GetDeviceFilter } from '@signageos/user-domain-model/dist/Mongo/Device/deviceModel';
 * import { IDeviceInfoModelRead } from '@signageos/user-domain-model/dist/Schema/Device/Info/deviceInfoModel';
 * export type IDeviceModelRead<T extends IDevice> = IDeviceModelReadOriginal<T, GetDeviceFilter<[IDeviceInfoModelRead]>>;
 * ```
 * And use the IDeviceModelRead in your application
 * instead of IDeviceModelRead<IDevice, DeviceFilter> imported from "./Schema/Device/deviceModel"
 */
const createDeviceModel = (conn, ...[deviceInfoModel]) => {
    return {
        getDeviceIterator() {
            const cursor = (0, exports.deviceCollection)(conn).find({}, { session: conn.session });
            return (0, ICursor_1.cursorIterator)(cursor);
        },
        getListByOrganizationsIterator(organizations, propertyFilter = {}) {
            return __awaiter(this, void 0, void 0, function* () {
                let filter = (0, organization_utils_1.getOrganizationFilter)(organizations);
                filter = yield (0, deviceModel_utils_2.convertPropertyFilterToMongoFilter)({ sourceMongoFilter: filter, propertyFilter, deviceInfoModel });
                const { pipeline, projection } = (0, deviceModel_utils_1.createPipelineFromPropertyFilter)(propertyFilter);
                pipeline.push({ $match: filter });
                pipeline.push({ $sort: { createdAt: -1 } });
                if (projection) {
                    pipeline.push(projection);
                }
                const aggregationCursor = (0, exports.deviceCollection)(conn).aggregate(pipeline, {
                    session: conn.session,
                });
                return (0, ICursor_1.cursorIterator)(aggregationCursor);
            });
        },
        fetchListByIdentityHashes(identityHashes, offset, limit) {
            return __awaiter(this, void 0, void 0, function* () {
                const filter = {
                    identityHash: { $in: identityHashes },
                };
                let query = (0, exports.deviceCollection)(conn).find(filter, { session: conn.session });
                query = query.sort({ createdAt: -1 });
                if (typeof offset !== 'undefined') {
                    query = query.skip(offset);
                }
                if (typeof limit !== 'undefined') {
                    query = query.limit(limit);
                }
                return query.toArray();
            });
        },
        fetchListByAccount(account, ignoreOrganizations = false) {
            const filter = {
                accountId: account.id,
            };
            if (ignoreOrganizations) {
                filter.organizationUid = {
                    $eq: null,
                };
            }
            return (0, exports.deviceCollection)(conn).find(filter, { session: conn.session }).sort({ createdAt: -1 }).toArray();
        },
        fetchListByOrganizations(organizations, propertyFilter = {}, propertySorter, offset, limit, fields) {
            return __awaiter(this, void 0, void 0, function* () {
                if (organizations.length === 0) {
                    return [];
                }
                let filter = (0, organization_utils_1.getOrganizationFilter)(organizations);
                filter = yield (0, deviceModel_utils_2.convertPropertyFilterToMongoFilter)({ sourceMongoFilter: filter, propertyFilter, deviceInfoModel });
                const { pipeline, projection } = (0, deviceModel_utils_1.getFetchListByOrganizationsProjection)({ filter: propertyFilter, fields });
                pipeline.push({ $match: filter });
                if (typeof propertySorter !== 'undefined') {
                    (0, deviceModel_utils_1.createPipelineSorterFromPropertySorter)(pipeline, propertySorter);
                }
                else {
                    pipeline.push({ $sort: { createdAt: -1 } });
                }
                if (projection) {
                    pipeline.push(projection);
                }
                let aggregationResultCursor = (0, exports.deviceCollection)(conn).aggregate(pipeline, {
                    session: conn.session,
                });
                if (offset) {
                    aggregationResultCursor = aggregationResultCursor.skip(offset);
                }
                if (limit) {
                    aggregationResultCursor = aggregationResultCursor.limit(limit);
                }
                return aggregationResultCursor.toArray();
            });
        },
        countByOrganizations(organizations, propertyFilter = {}) {
            var _a;
            return __awaiter(this, void 0, void 0, function* () {
                if (organizations.length === 0) {
                    return 0;
                }
                let filter = (0, organization_utils_1.getOrganizationFilter)(organizations);
                filter = yield (0, deviceModel_utils_2.convertPropertyFilterToMongoFilter)({ sourceMongoFilter: filter, propertyFilter, deviceInfoModel });
                const { pipeline } = (0, deviceModel_utils_1.createPipelineFromPropertyFilter)(propertyFilter);
                pipeline.push({ $match: filter }, { $group: { _id: 1, count: { $sum: 1 } } });
                const aggregationResultCursor = (0, exports.deviceCollection)(conn).aggregate(pipeline, {
                    session: conn.session,
                });
                const result = yield aggregationResultCursor.next();
                return (_a = result === null || result === void 0 ? void 0 : result.count) !== null && _a !== void 0 ? _a : 0;
            });
        },
        countMapOfOrganizations(organizations, propertyFilter) {
            return __awaiter(this, void 0, void 0, function* () {
                return yield this.fetchCountMapByProperty({
                    organizations,
                    property: 'organizationUid',
                    propertyFilter,
                });
            });
        },
        countMapOfApplicationTypes(organizations, propertyFilter) {
            return __awaiter(this, void 0, void 0, function* () {
                return yield this.fetchCountMapByProperty({
                    organizations,
                    property: 'applicationType',
                    propertyFilter,
                });
            });
        },
        countMapOfLocations(organizations, propertyFilter) {
            return __awaiter(this, void 0, void 0, function* () {
                return yield this.fetchCountMapByProperty({
                    organizations,
                    property: 'locationUid',
                    propertyFilter,
                });
            });
        },
        fetchCountMapByProperty(fetchParams) {
            return __awaiter(this, void 0, void 0, function* () {
                const { organizations, property, propertyFilter = {} } = fetchParams;
                if (organizations.length === 0) {
                    return new Map();
                }
                let filter = (0, organization_utils_1.getOrganizationFilter)(organizations);
                filter = yield (0, deviceModel_utils_2.convertPropertyFilterToMongoFilter)({ sourceMongoFilter: filter, propertyFilter, deviceInfoModel });
                const { pipeline } = (0, deviceModel_utils_1.createPipelineFromPropertyFilter)(propertyFilter);
                pipeline.push({ $match: filter }, { $group: { _id: `$${property}`, count: { $sum: 1 } } });
                const aggregationResultCursor = (0, exports.deviceCollection)(conn).aggregate(pipeline, {
                    session: conn.session,
                });
                const map = new Map();
                while (yield aggregationResultCursor.hasNext()) {
                    const row = yield aggregationResultCursor.next();
                    if (row && row._id !== null) {
                        map.set(row._id, row === null || row === void 0 ? void 0 : row.count);
                    }
                }
                return map;
            });
        },
        fetchIdentityHashesByOrganizations(organizations, propertyFilter = {}) {
            return __awaiter(this, void 0, void 0, function* () {
                if (organizations.length === 0) {
                    return [];
                }
                let filter = (0, organization_utils_1.getOrganizationFilter)(organizations);
                filter = yield (0, deviceModel_utils_2.convertPropertyFilterToMongoFilter)({ sourceMongoFilter: filter, propertyFilter, deviceInfoModel });
                const { pipeline } = (0, deviceModel_utils_1.createPipelineFromPropertyFilter)(propertyFilter);
                pipeline.push({ $match: filter }, { $project: { identityHash: 1 } });
                const aggregationResultCursor = (0, exports.deviceCollection)(conn).aggregate(pipeline, {
                    session: conn.session,
                });
                const result = yield aggregationResultCursor.toArray();
                return result.map((item) => item.identityHash);
            });
        },
        fetchGroupedIdentificationsByOrganizations(organizations, propertyFilter = {}) {
            return __awaiter(this, void 0, void 0, function* () {
                const index = {};
                if (organizations.length === 0) {
                    return index;
                }
                let filter = (0, organization_utils_1.getOrganizationFilter)(organizations);
                filter = yield (0, deviceModel_utils_2.convertPropertyFilterToMongoFilter)({ sourceMongoFilter: filter, propertyFilter, deviceInfoModel });
                const { pipeline } = (0, deviceModel_utils_1.createPipelineFromPropertyFilter)(propertyFilter);
                pipeline.push({ $match: filter }, { $project: { uid: 1, identityHash: 1, organizationUid: 1 } });
                const aggregationResultCursor = (0, exports.deviceCollection)(conn).aggregate(pipeline, {
                    session: conn.session,
                });
                const all = yield aggregationResultCursor.toArray();
                all.forEach((record) => {
                    if (index[record.organizationUid]) {
                        index[record.organizationUid].push({ identityHash: record.identityHash, uid: record.uid });
                    }
                    else {
                        index[record.organizationUid] = [{ identityHash: record.identityHash, uid: record.uid }];
                    }
                });
                return index;
            });
        },
        fetchByUid(uid) {
            return (0, exports.deviceCollection)(conn).findOne({ uid }, { session: conn.session });
        },
        fetchByIdentityHash(identityHash) {
            return __awaiter(this, void 0, void 0, function* () {
                return (0, exports.deviceCollection)(conn).findOne({ identityHash }, { session: conn.session });
            });
        },
        /**
         * Result is sorted by createdAt DESC
         */
        fetchListByPropertyFilter(propertyFilter, limit, fields) {
            return __awaiter(this, void 0, void 0, function* () {
                const filter = yield (0, deviceModel_utils_2.convertPropertyFilterToMongoFilter)({ sourceMongoFilter: {}, propertyFilter, deviceInfoModel });
                const { pipeline, projection } = (0, deviceModel_utils_1.getFetchListByOrganizationsProjection)({ filter: propertyFilter, fields });
                pipeline.push({ $match: filter }, { $sort: { createdAt: -1 } });
                if (projection) {
                    pipeline.push(projection);
                }
                let aggregationResultCursor = (0, exports.deviceCollection)(conn).aggregate(pipeline, {
                    session: conn.session,
                });
                if (limit) {
                    aggregationResultCursor = aggregationResultCursor.limit(limit);
                }
                return aggregationResultCursor.toArray();
            });
        },
        /**
         * Result is sorted by uid DESC
         */
        fetchUidListByPropertyFilter(propertyFilter, limit) {
            return __awaiter(this, void 0, void 0, function* () {
                const filter = yield (0, deviceModel_utils_2.convertPropertyFilterToMongoFilter)({ sourceMongoFilter: {}, propertyFilter, deviceInfoModel });
                const { pipeline } = (0, deviceModel_utils_1.createPipelineFromPropertyFilter)(propertyFilter);
                pipeline.push({ $match: filter }, { $sort: { uid: -1 } }, { $project: { _id: 0, uid: 1, identityHash: 1 } });
                let aggregationResultCursor = (0, exports.deviceCollection)(conn).aggregate(pipeline, {
                    session: conn.session,
                });
                if (limit) {
                    aggregationResultCursor = aggregationResultCursor.limit(limit);
                }
                return aggregationResultCursor.toArray();
            });
        },
        /**
         * Result is sorted by uid DESC
         */
        fetchUidListByOrganizationUids(organizationUids, propertyFilter, limit) {
            return __awaiter(this, void 0, void 0, function* () {
                const organizationfilter = {
                    organizationUid: {
                        $in: organizationUids,
                    },
                };
                const filter = yield (0, deviceModel_utils_2.convertPropertyFilterToMongoFilter)({ sourceMongoFilter: organizationfilter, propertyFilter, deviceInfoModel });
                const { pipeline } = (0, deviceModel_utils_1.createPipelineFromPropertyFilter)(propertyFilter);
                pipeline.push({ $match: filter }, { $sort: { uid: -1 } }, { $project: { _id: 0, uid: 1, identityHash: 1 } });
                let aggregationResultCursor = (0, exports.deviceCollection)(conn).aggregate(pipeline, {
                    session: conn.session,
                });
                if (limit) {
                    aggregationResultCursor = aggregationResultCursor.limit(limit);
                }
                return aggregationResultCursor.toArray();
            });
        },
        fetchTags(identityHash, paginationAndSorting) {
            return __awaiter(this, void 0, void 0, function* () {
                const pipeline = [
                    { $project: { identityHash: 1, tagUids: 1 } },
                    { $match: { identityHash } },
                    { $unwind: '$tagUids' },
                    {
                        $lookup: {
                            from: 'organizationTag',
                            localField: 'tagUids',
                            foreignField: 'uid',
                            as: 'tag',
                        },
                    },
                    { $unwind: '$tag' },
                    { $replaceRoot: { newRoot: '$tag' } },
                    { $project: { _id: 0 } },
                ];
                const sorting = (0, pagination_1.getSorting)({
                    defaultSorting: {
                        field: 'createdAt',
                        order: paginationTypes_1.SortOrder.DESC,
                    },
                    sorting: paginationAndSorting === null || paginationAndSorting === void 0 ? void 0 : paginationAndSorting.sorting,
                });
                const sortPipeline = (0, utils_1.getPipeline)({ sorting, pagination: paginationAndSorting === null || paginationAndSorting === void 0 ? void 0 : paginationAndSorting.pagination });
                const result = yield (0, exports.deviceCollection)(conn).aggregate([...pipeline, ...sortPipeline], { session: conn.session });
                return result.toArray();
            });
        },
        countByPropertyFilter(organizations, propertyFilter, pagination) {
            var _a, _b;
            return __awaiter(this, void 0, void 0, function* () {
                const offset = pagination === null || pagination === void 0 ? void 0 : pagination.offset;
                const limit = pagination === null || pagination === void 0 ? void 0 : pagination.limit;
                const organizationfilter = (0, organization_utils_1.getOrganizationFilter)(organizations);
                const filter = yield (0, deviceModel_utils_2.convertPropertyFilterToMongoFilter)({ sourceMongoFilter: organizationfilter, propertyFilter, deviceInfoModel });
                const { pipeline } = (0, deviceModel_utils_1.createPipelineFromPropertyFilter)(propertyFilter);
                const result = yield (0, exports.deviceCollection)(conn)
                    .aggregate([
                    ...pipeline,
                    {
                        $match: filter,
                    },
                    { $count: 'count' },
                    ...(offset ? [{ $skip: offset }] : []),
                    ...(limit ? [{ $limit: offset }] : []),
                ], {
                    session: conn.session,
                })
                    .toArray();
                return (_b = (_a = result[0]) === null || _a === void 0 ? void 0 : _a.count) !== null && _b !== void 0 ? _b : 0;
            });
        },
        getDeprovisionedCountByOrganizations(organizations, since, before) {
            var _a;
            return __awaiter(this, void 0, void 0, function* () {
                if (organizations.length === 0) {
                    return 0;
                }
                const pipeline = [
                    {
                        $match: {
                            lastOrganizationUid: {
                                $in: organizations.map((organization) => organization.uid),
                            },
                            $and: [
                                ...(typeof since !== 'undefined' ? [{ lastDeprovisionAt: { $gt: since } }] : [{}]),
                                ...(typeof before !== 'undefined' ? [{ lastDeprovisionAt: { $lt: before } }] : [{}]),
                            ],
                        },
                    },
                    { $group: { _id: 1, count: { $sum: 1 } } },
                ];
                const aggregationResultCursor = (0, exports.deviceCollection)(conn).aggregate(pipeline, {
                    session: conn.session,
                });
                const result = yield aggregationResultCursor.next();
                return (_a = result === null || result === void 0 ? void 0 : result.count) !== null && _a !== void 0 ? _a : 0;
            });
        },
        fetchDeprovisionedSince(organizations, since, paginationAndSorting) {
            return __awaiter(this, void 0, void 0, function* () {
                if (organizations.length === 0) {
                    return [];
                }
                const matcher = {
                    lastOrganizationUid: {
                        $in: organizations.map((organization) => organization.uid),
                    },
                    lastDeprovisionAt: { $gt: since },
                };
                const sorting = (0, deviceModel_utils_1.getDeprovisionedDeviceSorting)(paginationAndSorting === null || paginationAndSorting === void 0 ? void 0 : paginationAndSorting.sorting);
                const pipeline = (0, utils_1.getPipeline)({ matcher, sorting, pagination: paginationAndSorting === null || paginationAndSorting === void 0 ? void 0 : paginationAndSorting.pagination });
                return (0, exports.deviceCollection)(conn).aggregate(pipeline, { session: conn.session }).toArray();
            });
        },
        create(uid, identityHash, application, createdAt) {
            return __awaiter(this, void 0, void 0, function* () {
                const newRow = {
                    uid,
                    identityHash,
                    applicationType: application.type,
                    createdAt,
                };
                yield (0, exports.deviceCollection)(conn).insertOne(newRow, { session: conn.session });
            });
        },
        updateModel(deviceRow, model) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.deviceCollection)(conn).updateOne({ identityHash: deviceRow.identityHash }, {
                    $set: {
                        model,
                    },
                }, { session: conn.session });
            });
        },
        updateSerialNumber(deviceRow, serialNumber) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.deviceCollection)(conn).updateOne({ identityHash: deviceRow.identityHash }, {
                    $set: {
                        serialNumber,
                    },
                }, { session: conn.session });
            });
        },
        updateBrand(deviceRow, brand) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.deviceCollection)(conn).updateOne({ identityHash: deviceRow.identityHash }, {
                    $set: {
                        brand,
                    },
                }, { session: conn.session });
            });
        },
        updateOSVersion(deviceRow, osVersion) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.deviceCollection)(conn).updateOne({ identityHash: deviceRow.identityHash }, { $set: { osVersion } }, { session: conn.session });
            });
        },
        updateName(deviceRow, name) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.deviceCollection)(conn).updateOne({ identityHash: deviceRow.identityHash }, {
                    $set: {
                        name,
                        nameLowerCase: name.toLowerCase(),
                    },
                }, { session: conn.session });
            });
        },
        updateExtendedManagementSince(deviceRow, extendedManagementSince) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.deviceCollection)(conn).updateOne({ identityHash: deviceRow.identityHash }, {
                    $set: {
                        extendedManagementSince,
                    },
                }, { session: conn.session });
            });
        },
        updateExtendedManagementPairCode(deviceRow, extendedManagementPairCode) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.deviceCollection)(conn).updateOne({ identityHash: deviceRow.identityHash }, {
                    $set: {
                        extendedManagementPairCode,
                    },
                }, { session: conn.session });
            });
        },
        updateAccount(deviceRow, account) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.deviceCollection)(conn).updateOne({ identityHash: deviceRow.identityHash }, {
                    $set: {
                        accountId: account.id,
                    },
                }, { session: conn.session });
            });
        },
        removeAccount(deviceRow) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.deviceCollection)(conn).updateOne({ identityHash: deviceRow.identityHash }, {
                    $set: {
                        accountId: null,
                    },
                }, { session: conn.session });
            });
        },
        updateOrganization(deviceRow, organization) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.deviceCollection)(conn).updateOne({ identityHash: deviceRow.identityHash }, {
                    $set: {
                        organizationUid: organization.uid,
                        lastOrganizationUid: deviceRow.organizationUid,
                    },
                }, { session: conn.session });
            });
        },
        removeOrganization(deviceRow) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.deviceCollection)(conn).updateOne({ identityHash: deviceRow.identityHash }, {
                    $set: {
                        organizationUid: null,
                        lastOrganizationUid: deviceRow.organizationUid,
                    },
                }, { session: conn.session });
            });
        },
        setLastProvisionedAt(deviceRow, provisionedAt) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.deviceCollection)(conn).updateOne({ identityHash: deviceRow.identityHash }, {
                    $set: {
                        lastProvisionAt: provisionedAt,
                    },
                }, { session: conn.session });
            });
        },
        setFirstProvisionedAt(deviceRow, provisionedAt) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.deviceCollection)(conn).updateOne({ identityHash: deviceRow.identityHash }, { $set: { firstProvisionedAt: provisionedAt } }, { session: conn.session });
            });
        },
        setLastDeprovisionedAt(deviceRow, deprovisionedAt) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.deviceCollection)(conn).updateOne({ identityHash: deviceRow.identityHash }, {
                    $set: {
                        lastDeprovisionAt: deprovisionedAt,
                    },
                }, { session: conn.session });
            });
        },
        updatePinCode(deviceRow, pinCode) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.deviceCollection)(conn).updateOne({ identityHash: deviceRow.identityHash }, {
                    $set: {
                        pinCode,
                    },
                }, { session: conn.session });
            });
        },
        updateFirmwareType(deviceRow, firmwareType) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.deviceCollection)(conn).updateOne({ identityHash: deviceRow.identityHash }, {
                    $set: {
                        firmwareType,
                    },
                }, { session: conn.session });
            });
        },
        updateFirmwareVersion(deviceRow, firmwareVersion) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.deviceCollection)(conn).updateOne({ identityHash: deviceRow.identityHash }, {
                    $set: {
                        firmwareVersion,
                    },
                }, { session: conn.session });
            });
        },
        markBanned(deviceRow, bannedSince) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.deviceCollection)(conn).updateOne({ identityHash: deviceRow.identityHash }, {
                    $set: {
                        bannedSince,
                    },
                }, { session: conn.session });
            });
        },
        markApproved(deviceRow) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.deviceCollection)(conn).updateOne({ identityHash: deviceRow.identityHash }, {
                    $set: {
                        bannedSince: null,
                    },
                }, { session: conn.session });
            });
        },
        changeSubscriptionType(deviceRow, subscriptionType) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.deviceCollection)(conn).updateOne({ identityHash: deviceRow.identityHash }, {
                    $set: {
                        subscriptionType: subscriptionType ? subscriptionType.toString() : null,
                    },
                }, { session: conn.session });
            });
        },
        fetchAllFirmwareTypes(applicationType) {
            return __awaiter(this, void 0, void 0, function* () {
                return (0, exports.deviceCollection)(conn).distinct('firmwareType', { applicationType }, { session: conn.session });
            });
        },
        /**
         * Returns list of model types which are present in devices for given organizations
         * @param organizations - array of organizations
         * @param propertyFilter - property filter to filter out devices
         */
        fetchModelsByOrganizations(organizations, propertyFilter = {}) {
            return __awaiter(this, void 0, void 0, function* () {
                if (organizations.length === 0) {
                    return [];
                }
                const modelFilter = {
                    model: {
                        $exists: true,
                        $ne: null,
                    },
                };
                let filter = (0, organization_utils_1.getOrganizationFilter)(organizations);
                filter = yield (0, deviceModel_utils_2.convertPropertyFilterToMongoFilter)({ sourceMongoFilter: filter, propertyFilter, deviceInfoModel });
                const { pipeline } = (0, deviceModel_utils_1.createPipelineFromPropertyFilter)(propertyFilter);
                filter = Object.assign(Object.assign({}, filter), modelFilter);
                const models = yield (0, exports.deviceCollection)(conn)
                    .aggregate([
                    ...pipeline,
                    {
                        $match: filter,
                    },
                    { $group: { _id: '$model' } },
                    { $sort: { _id: 1 } },
                ], { session: conn.session })
                    .toArray();
                return models.map((model) => model._id);
            });
        },
        fetchApplicationTypesByOrganizations(organizations, propertyFilter = {}) {
            return __awaiter(this, void 0, void 0, function* () {
                if (organizations.length === 0) {
                    return [];
                }
                const organizationFilter = (0, organization_utils_1.getOrganizationFilter)(organizations);
                const filter = yield (0, deviceModel_utils_2.convertPropertyFilterToMongoFilter)({ sourceMongoFilter: organizationFilter, propertyFilter, deviceInfoModel });
                const { pipeline } = (0, deviceModel_utils_1.createPipelineFromPropertyFilter)(propertyFilter);
                const applicationTypes = yield (0, exports.deviceCollection)(conn)
                    .aggregate([
                    ...pipeline,
                    {
                        $match: filter,
                    },
                    { $group: { _id: '$applicationType' } },
                    { $sort: { _id: 1 } },
                ], { session: conn.session })
                    .toArray();
                return applicationTypes.map((applicationType) => applicationType._id);
            });
        },
        /**
         * Returns list of firmware versions which are present in devices for given organizations
         * @param organizations - array of organizations
         * @param propertyFilter - property filter to filter out devices
         */
        fetchFirmwareVersionsByOrganizations(organizations, propertyFilter = {}) {
            return __awaiter(this, void 0, void 0, function* () {
                if (organizations.length === 0) {
                    return [];
                }
                const firmwareFilter = {
                    firmwareVersion: {
                        $exists: true,
                        $ne: null,
                    },
                };
                let filter = (0, organization_utils_1.getOrganizationFilter)(organizations);
                filter = yield (0, deviceModel_utils_2.convertPropertyFilterToMongoFilter)({ sourceMongoFilter: filter, propertyFilter, deviceInfoModel });
                const { pipeline } = (0, deviceModel_utils_1.createPipelineFromPropertyFilter)(propertyFilter);
                filter = Object.assign(Object.assign({}, filter), firmwareFilter);
                const firmwareVersions = yield (0, exports.deviceCollection)(conn)
                    .aggregate([
                    ...pipeline,
                    {
                        $match: filter,
                    },
                    { $group: { _id: '$firmwareVersion' } },
                    { $sort: { _id: 1 } },
                ], { session: conn.session })
                    .toArray();
                return firmwareVersions.map((firmwareVersion) => firmwareVersion._id);
                return (0, exports.deviceCollection)(conn).distinct('firmwareVersion', filter, { session: conn.session });
            });
        },
        assignTag(deviceRow, tagUid) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.deviceCollection)(conn).updateOne({ identityHash: deviceRow.identityHash }, {
                    $push: {
                        tagUids: tagUid,
                    },
                }, { session: conn.session });
            });
        },
        removeTag(deviceRow, tagUid) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.deviceCollection)(conn).updateOne({ identityHash: deviceRow.identityHash }, {
                    $pull: {
                        tagUids: tagUid,
                    },
                }, { session: conn.session });
            });
        },
        assignOrUpdatePolicy(deviceRow, policy) {
            var _a;
            return __awaiter(this, void 0, void 0, function* () {
                const policyAlreadyExisted = (_a = deviceRow.policies) === null || _a === void 0 ? void 0 : _a.some((devicePolicy) => devicePolicy.uid === policy.uid);
                const operation = policyAlreadyExisted ? { $set: { 'policies.$[policyItem]': policy } } : { $push: { policies: policy } };
                const arrayFiltersBox = policyAlreadyExisted ? { arrayFilters: [{ 'policyItem.uid': policy.uid }] } : {};
                yield (0, exports.deviceCollection)(conn).updateOne({ identityHash: deviceRow.identityHash }, operation, Object.assign({ session: conn.session }, arrayFiltersBox));
            });
        },
        removePolicy(deviceRow, policy) {
            return __awaiter(this, void 0, void 0, function* () {
                if (typeof deviceRow.policies !== 'undefined') {
                    yield (0, exports.deviceCollection)(conn).updateOne({ identityHash: deviceRow.identityHash }, { $pull: { policies: { uid: policy.uid } } }, { session: conn.session });
                }
            });
        },
        fetchDevicesDistributionByDevicePlan(provisionedSince, provisionedBefore, isProduction, propertyFilter = {}) {
            return __awaiter(this, void 0, void 0, function* () {
                const propFilter = yield (0, deviceModel_utils_2.convertPropertyFilterToMongoFilter)({ sourceMongoFilter: {}, propertyFilter, deviceInfoModel });
                const { pipeline } = (0, deviceModel_utils_1.createPipelineFromPropertyFilter)(propertyFilter);
                let filter = Object.assign(Object.assign({}, createStatisticsProvisionedFilter(provisionedSince, provisionedBefore)), propFilter);
                let joinedOrganizationFilter = { 'org.isCompany': false };
                if (isProduction) {
                    joinedOrganizationFilter = { 'org.productionSince': { $exists: true } };
                }
                const aggregationResult = yield (0, exports.deviceCollection)(conn)
                    .aggregate([
                    ...pipeline,
                    { $match: filter },
                    { $match: { organizationUid: { $ne: null } } },
                    {
                        $addFields: {
                            provYM: { $dateToString: { format: '%Y%m', date: '$firstProvisionedAt' } },
                            deprovYM: { $dateToString: { format: '%Y%m', date: '$lastDeprovisionAt' } },
                        },
                    },
                    {
                        $lookup: {
                            from: 'organization',
                            localField: 'organizationUid',
                            foreignField: 'uid',
                            as: 'org',
                        },
                    },
                    { $match: joinedOrganizationFilter },
                    { $group: { _id: '$subscriptionType', total: { $sum: 1 } } },
                ])
                    .toArray();
                const defaultCounts = (0, organizationModel_1.createDefaultDistributionByDevicePlan)();
                const counts = aggregationResult.reduce((accumulator, carry) => {
                    if (carry._id === null) {
                        return accumulator;
                    }
                    return Object.assign(Object.assign({}, accumulator), { [carry._id]: carry.total });
                }, defaultCounts);
                return (0, organizationModel_2.removeObsoleteDevicePlans)(counts);
            });
        },
        fetchOrganizationDistributionByDevicePlan(organizationUid, provisionedSince, provisionedBefore) {
            return __awaiter(this, void 0, void 0, function* () {
                const filter = Object.assign(Object.assign({}, createStatisticsProvisionedFilter(provisionedSince, provisionedBefore)), { organizationUid: organizationUid });
                const defaultCounts = (0, organizationModel_1.createDefaultDistributionByDevicePlan)();
                const aggregationResult = yield (0, exports.deviceCollection)(conn)
                    .aggregate([
                    { $match: filter },
                    {
                        $lookup: {
                            from: 'organization',
                            localField: 'organizationUid',
                            foreignField: 'uid',
                            as: 'org',
                        },
                    },
                    { $group: { _id: '$subscriptionType', total: { $sum: 1 } } },
                ])
                    .toArray();
                const counts = aggregationResult.reduce((accumulator, carry) => {
                    if (carry._id === null) {
                        return accumulator;
                    }
                    return Object.assign(Object.assign({}, accumulator), { [carry._id]: carry.total });
                }, defaultCounts);
                return (0, organizationModel_2.removeObsoleteDevicePlans)(counts);
            });
        },
        fetchOrganizationsDistributionByDevicePlan(organizationUids, createdSince, createdBefore, propertyFilter = {}) {
            return __awaiter(this, void 0, void 0, function* () {
                const propFilter = yield (0, deviceModel_utils_2.convertPropertyFilterToMongoFilter)({ sourceMongoFilter: {}, propertyFilter, deviceInfoModel });
                const { pipeline } = (0, deviceModel_utils_1.createPipelineFromPropertyFilter)(propertyFilter);
                const filter = Object.assign(Object.assign(Object.assign({}, createStatisticsProvisionedFilter(createdSince, createdBefore)), { organizationUid: { $in: organizationUids } }), propFilter);
                const defaultOrgsStatistics = {};
                const aggregationResult = yield (0, exports.deviceCollection)(conn)
                    .aggregate([
                    ...pipeline,
                    { $match: filter },
                    {
                        $lookup: {
                            from: 'organization',
                            localField: 'organizationUid',
                            foreignField: 'uid',
                            as: 'org',
                        },
                    },
                    { $group: { _id: { subscriptionType: '$subscriptionType', organizationUid: '$organizationUid' }, total: { $sum: 1 } } },
                    { $match: { $and: [{ '_id.subscriptionType': { $ne: null } }, { '_id.organizationUid': { $ne: null } }] } },
                ])
                    .toArray();
                const counts = aggregationResult.reduce((accumulator, carry) => {
                    if (!accumulator[carry._id.organizationUid]) {
                        accumulator = Object.assign(Object.assign({}, accumulator), { [carry._id.organizationUid]: (0, organizationModel_1.createDefaultDistributionByDevicePlan)() });
                    }
                    return Object.assign(Object.assign({}, accumulator), { [carry._id.organizationUid]: Object.assign(Object.assign({}, accumulator[carry._id.organizationUid]), { [carry._id.subscriptionType]: carry.total }) });
                }, defaultOrgsStatistics);
                return counts;
            });
        },
        fetchListByCompanyUids(companyUids) {
            return __awaiter(this, void 0, void 0, function* () {
                const organizationFilter = {
                    parentUid: { $in: companyUids },
                };
                return (0, exports.organizationCollection)(conn)
                    .aggregate([
                    { $match: organizationFilter },
                    {
                        $lookup: {
                            from: 'device',
                            foreignField: 'organizationUid',
                            localField: 'uid',
                            as: 'device',
                        },
                    },
                    {
                        $lookup: {
                            from: 'organization',
                            foreignField: 'uid',
                            localField: 'parentUid',
                            as: 'parentOrganization',
                        },
                    },
                    {
                        $addFields: {
                            productionOrTest: {
                                $cond: {
                                    if: { $ne: [{ $type: '$productionSince' }, 'missing'] },
                                    then: 'production',
                                    else: 'test',
                                },
                            },
                            organizationName: '$name',
                        },
                    },
                    { $unwind: '$parentOrganization' },
                    {
                        $addFields: {
                            companyName: '$parentOrganization.name',
                        },
                    },
                    { $project: { device: 1, _id: 0, productionOrTest: 1, organizationName: 1, companyName: 1 } },
                    { $unwind: '$device' },
                    {
                        $replaceRoot: {
                            newRoot: {
                                $mergeObjects: [
                                    { productionOrTest: '$productionOrTest', organizationName: '$organizationName', companyName: '$companyName' },
                                    '$device',
                                ],
                            },
                        },
                    },
                    { $project: { _id: 0 } },
                    { $sort: { organizationName: 1 } },
                ])
                    .toArray();
            });
        },
        fetchByPolicy(policy) {
            return __awaiter(this, void 0, void 0, function* () {
                const filter = { 'policies.uid': policy.uid };
                const pipeline = [{ $match: filter }];
                const options = {
                    session: conn.session,
                };
                return (0, exports.deviceCollection)(conn).aggregate(pipeline, options).toArray();
            });
        },
        countByPolicy(policy) {
            return __awaiter(this, void 0, void 0, function* () {
                const filter = { 'policies.uid': policy.uid };
                return (0, exports.deviceCollection)(conn).countDocuments(filter, { session: conn.session });
            });
        },
        countByPolicyAndApplicationType(policy, applicationType) {
            return __awaiter(this, void 0, void 0, function* () {
                const filter = { applicationType, 'policies.uid': policy.uid };
                return (0, exports.deviceCollection)(conn).countDocuments(filter, { session: conn.session });
            });
        },
        assignDeviceToLocation(deviceRow, location) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.deviceCollection)(conn).updateOne({ uid: deviceRow.uid }, { $set: { locationUid: location.uid } }, { session: conn.session });
            });
        },
        unassignDeviceFromLocation(deviceRow) {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, exports.deviceCollection)(conn).updateOne({ identityHash: deviceRow.identityHash }, { $set: { locationUid: null } }, { session: conn.session });
            });
        },
        fetchOrganizationsUidsDevicesBelongTo(organizations, propertyFilter) {
            return __awaiter(this, void 0, void 0, function* () {
                const organizationFilter = (0, organization_utils_1.getOrganizationFilter)(organizations);
                const filter = yield (0, deviceModel_utils_2.convertPropertyFilterToMongoFilter)({ sourceMongoFilter: organizationFilter, propertyFilter, deviceInfoModel });
                const { pipeline } = (0, deviceModel_utils_1.createPipelineFromPropertyFilter)(propertyFilter);
                const organizationUids = yield (0, exports.deviceCollection)(conn)
                    .aggregate([
                    ...pipeline,
                    {
                        $match: filter,
                    },
                    { $group: { _id: '$organizationUid' } },
                    { $sort: { _id: 1 } },
                ], { session: conn.session })
                    .toArray();
                return organizationUids.map((organizationUid) => organizationUid._id);
            });
        },
        fetchOsVersionsByOrganizations(organizations, propertyFilter = {}) {
            return __awaiter(this, void 0, void 0, function* () {
                if (organizations.length === 0) {
                    return [];
                }
                const osFilter = {
                    osVersion: {
                        $exists: true,
                        $ne: null,
                    },
                };
                let filter = (0, organization_utils_1.getOrganizationFilter)(organizations);
                filter = yield (0, deviceModel_utils_2.convertPropertyFilterToMongoFilter)({ sourceMongoFilter: filter, propertyFilter, deviceInfoModel });
                const { pipeline } = (0, deviceModel_utils_1.createPipelineFromPropertyFilter)(propertyFilter);
                filter = Object.assign(Object.assign({}, filter), osFilter);
                const osVersions = yield (0, exports.deviceCollection)(conn)
                    .aggregate([
                    ...pipeline,
                    {
                        $match: filter,
                    },
                    { $group: { _id: '$osVersion' } },
                    { $sort: { _id: 1 } },
                ], { session: conn.session })
                    .toArray();
                return osVersions.map((osVersion) => osVersion._id);
            });
        },
        fetchBrandsByOrganizations(organizations, propertyFilter = {}) {
            return __awaiter(this, void 0, void 0, function* () {
                if (organizations.length === 0) {
                    return [];
                }
                const brandFilter = {
                    brand: {
                        $exists: true,
                        $ne: null,
                    },
                };
                let filter = (0, organization_utils_1.getOrganizationFilter)(organizations);
                filter = yield (0, deviceModel_utils_2.convertPropertyFilterToMongoFilter)({ sourceMongoFilter: filter, propertyFilter, deviceInfoModel });
                const { pipeline } = (0, deviceModel_utils_1.createPipelineFromPropertyFilter)(propertyFilter);
                filter = Object.assign(Object.assign({}, filter), brandFilter);
                const brands = yield (0, exports.deviceCollection)(conn)
                    .aggregate([
                    ...pipeline,
                    {
                        $match: filter,
                    },
                    { $group: { _id: '$brand' } },
                    { $sort: { _id: 1 } },
                ], { session: conn.session })
                    .toArray();
                return brands.map((brand) => brand._id);
            });
        },
        fetchCreatedBetween({ createdSince, createdUntil }) {
            return __awaiter(this, void 0, void 0, function* () {
                const pipeline = [
                    {
                        $match: {
                            createdAt: Object.assign({ $lt: createdUntil }, (createdSince ? { $gte: createdSince } : {})),
                        },
                    },
                    {
                        $sort: { createdAt: 1 },
                    },
                ];
                const options = {
                    session: conn.session,
                };
                return (0, exports.deviceCollection)(conn).aggregate(pipeline, options).toArray();
            });
        },
        fetchListOfLocationUidsByDeviceIdentityHashes(identityHashes) {
            return __awaiter(this, void 0, void 0, function* () {
                const filter = [
                    {
                        identityHash: { $in: identityHashes },
                        locationUid: { $exists: true, $ne: null },
                    },
                ];
                return yield (0, exports.deviceCollection)(conn).distinct('locationUid', { $and: filter });
            });
        },
    };
};
exports.createDeviceModel = createDeviceModel;
function createStatisticsProvisionedFilter(provisionedSince, provisionedBefore) {
    let filter = {};
    if (provisionedSince) {
        filter = Object.assign(Object.assign({}, filter), { firstProvisionedAt: { $gte: provisionedSince } });
    }
    else {
        filter = Object.assign(Object.assign({}, filter), { firstProvisionedAt: { $gt: new Date(0) } });
    }
    if (provisionedBefore) {
        if (provisionedSince) {
            filter = Object.assign(Object.assign({}, filter), { firstProvisionedAt: { $gte: provisionedSince, $lte: provisionedBefore } });
        }
        else {
            filter = Object.assign(Object.assign({}, filter), { firstProvisionedAt: { $lte: provisionedBefore } });
        }
    }
    return filter;
}
exports.createStatisticsProvisionedFilter = createStatisticsProvisionedFilter;
function createStatisticsDeprovisionedFilter(deprovisionedSince, deprovisionedBefore, lastOrganizationUid) {
    let filter = {};
    if (lastOrganizationUid) {
        filter = { lastOrganizationUid };
    }
    if (deprovisionedSince) {
        filter = Object.assign(Object.assign({}, filter), { lastDeprovisionAt: { $gte: deprovisionedSince } });
    }
    else {
        filter = Object.assign(Object.assign({}, filter), { lastDeprovisionAt: { $gt: new Date(0) } });
    }
    if (deprovisionedBefore) {
        if (deprovisionedSince) {
            filter = Object.assign(Object.assign({}, filter), { lastDeprovisionAt: { $gte: deprovisionedSince, $lte: deprovisionedBefore } });
        }
        else {
            filter = Object.assign(Object.assign({}, filter), { lastDeprovisionAt: { $lte: deprovisionedBefore } });
        }
    }
    return filter;
}
exports.createStatisticsDeprovisionedFilter = createStatisticsDeprovisionedFilter;
//# sourceMappingURL=deviceModel.js.map