/// <reference types="mongoose/types/aggregate" />
/// <reference types="mongoose/types/callback" />
/// <reference types="mongoose/types/collection" />
/// <reference types="mongoose/types/connection" />
/// <reference types="mongoose/types/cursor" />
/// <reference types="mongoose/types/document" />
/// <reference types="mongoose/types/error" />
/// <reference types="mongoose/types/expressions" />
/// <reference types="mongoose/types/helpers" />
/// <reference types="mongoose/types/middlewares" />
/// <reference types="mongoose/types/indexes" />
/// <reference types="mongoose/types/models" />
/// <reference types="mongoose/types/mongooseoptions" />
/// <reference types="mongoose/types/pipelinestage" />
/// <reference types="mongoose/types/populate" />
/// <reference types="mongoose/types/query" />
/// <reference types="mongoose/types/schemaoptions" />
/// <reference types="mongoose/types/schematypes" />
/// <reference types="mongoose/types/session" />
/// <reference types="mongoose/types/types" />
/// <reference types="mongoose/types/utility" />
/// <reference types="mongoose/types/validation" />
/// <reference types="mongoose/types/virtuals" />
/// <reference types="mongoose" />
/// <reference types="mongoose/types/inferschematype" />
import { Filter } from 'mongodb';
import { IMongodbConnection } from '@signageos/lib/dist/MongoDB/mongoDBConnectionFactory';
import { DeviceFilter as FullDeviceFilter } from '@signageos/common-types/dist/Device/deviceFilter';
import { IDeviceModelRead, IDeviceModelWrite, IDevice } from '../../Schema/Device/deviceModel';
import { IDeviceInfoModelRead } from '../../Schema/Device/Info/deviceInfoModel';
export declare const deviceCollection: (conn: IMongodbConnection) => import("mongoose").Collection<import("mongoose").AnyObject>;
export declare const organizationCollection: (conn: IMongodbConnection) => import("mongoose").Collection<import("mongoose").AnyObject>;
export declare const prepareDeviceTable: (conn: IMongodbConnection) => Promise<void>;
export declare type GetDeviceFilter<ExtraModels extends [IDeviceInfoModelRead] | []> = ExtraModels extends [IDeviceInfoModelRead] ? FullDeviceFilter : Omit<FullDeviceFilter, 'search' | 'maxStorageStatusPercentage' | 'minStorageStatusPercentage'>;
/**
 * The second spread parameter ...extraModels is optional.
 * But if it's empty, you cannot use some features of filtering like search, maxStorageStatusPercentage, minStorageStatusPercentage.
 * Use the following TypeScript construction in you application if you are using deviceModel with DeviceFilter:
 * ```ts
 * import {
 * 	IDevice,
 * 	IDeviceModelRead as IDeviceModelReadOriginal,
 * } from '@signageos/user-domain-model/dist/Schema/Device/deviceModel';
 * import { GetDeviceFilter } from '@signageos/user-domain-model/dist/Mongo/Device/deviceModel';
 * import { IDeviceInfoModelRead } from '@signageos/user-domain-model/dist/Schema/Device/Info/deviceInfoModel';
 * export type IDeviceModelRead<T extends IDevice> = IDeviceModelReadOriginal<T, GetDeviceFilter<[IDeviceInfoModelRead]>>;
 * ```
 * And use the IDeviceModelRead in your application
 * instead of IDeviceModelRead<IDevice, DeviceFilter> imported from "./Schema/Device/deviceModel"
 */
export declare const createDeviceModel: <ExtraModels extends [] | [IDeviceInfoModelRead]>(conn: IMongodbConnection, ...[deviceInfoModel]: ExtraModels) => IDeviceModelRead<IDevice, GetDeviceFilter<ExtraModels>> & IDeviceModelWrite<IDevice>;
export declare function createStatisticsProvisionedFilter(provisionedSince?: Date, provisionedBefore?: Date): Filter<IDevice>;
export declare function createStatisticsDeprovisionedFilter(deprovisionedSince?: Date, deprovisionedBefore?: Date, lastOrganizationUid?: string): Filter<IDevice>;
//# sourceMappingURL=deviceModel.d.ts.map