"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceVerificationModel = exports.prepareDeviceVerificationTable = void 0;
const collections_1 = require("../../Lib/collections");
const deviceVerificationCollection = (conn) => conn.connection.collection(collections_1.DeviceCollection.Verification);
const prepareDeviceVerificationTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield deviceVerificationCollection(conn).createIndex({ id: 1 }, { name: 'id', unique: true, background: true });
    yield deviceVerificationCollection(conn).createIndex({ deviceIdentityHash: 1 }, { name: 'deviceIdentityHash', unique: true, background: true });
    yield deviceVerificationCollection(conn).createIndex({ hash: 1 }, { name: 'hash', unique: true, background: true });
    yield deviceVerificationCollection(conn).createIndex({ deviceIdentityHash: 1, hash: 1 }, { name: 'deviceIdentityHash_hash', background: true });
});
exports.prepareDeviceVerificationTable = prepareDeviceVerificationTable;
const createDeviceVerificationModel = (conn) => ({
    fetchByDeviceAndHash(device, hash) {
        return deviceVerificationCollection(conn).findOne({
            deviceIdentityHash: device.identityHash,
            hash,
        }, { session: conn.session });
    },
    fetchByHash(hash) {
        return deviceVerificationCollection(conn).findOne({ hash }, { session: conn.session });
    },
    fetchByDevice(device) {
        return deviceVerificationCollection(conn).findOne({
            deviceIdentityHash: device.identityHash,
        }, { session: conn.session });
    },
    fetchById(id) {
        return deviceVerificationCollection(conn).findOne({ id }, { session: conn.session });
    },
    fetchUnverifiedByHash(hash) {
        return deviceVerificationCollection(conn).findOne({
            hash,
            verifiedAt: { $eq: null },
        }, { session: conn.session });
    },
    create(uid, device, hash, createdAt) {
        return __awaiter(this, void 0, void 0, function* () {
            const newRow = {
                id: uid,
                createdAt,
                deviceIdentityHash: device.identityHash,
                hash,
                verifiedAt: null,
                verifierId: null,
            };
            yield deviceVerificationCollection(conn).insertOne(newRow, { session: conn.session });
        });
    },
    verify(deviceVerificationRow, verifier, verifiedAt) {
        return __awaiter(this, void 0, void 0, function* () {
            yield deviceVerificationCollection(conn).updateOne({ id: deviceVerificationRow.id }, {
                $set: {
                    verifiedAt,
                    verifierId: verifier ? verifier.id : null,
                },
            }, { session: conn.session });
        });
    },
    invalidate(deviceVerificationRow) {
        return __awaiter(this, void 0, void 0, function* () {
            yield deviceVerificationCollection(conn).updateOne({ id: deviceVerificationRow.id }, {
                $set: {
                    verifiedAt: null,
                    verifierId: null,
                },
            }, { session: conn.session });
        });
    },
});
exports.createDeviceVerificationModel = createDeviceVerificationModel;
//# sourceMappingURL=deviceVerificationModel.js.map