"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceSessionModel = exports.prepareDeviceSessionTable = exports.deviceSessionCollection = void 0;
const collections_1 = require("../../Lib/collections");
const deviceSessionCollection = (conn) => conn.connection.collection(collections_1.DeviceCollection.Session);
exports.deviceSessionCollection = deviceSessionCollection;
const THIRTY_DAYS_IN_SECS = 2592000;
const prepareDeviceSessionTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield (0, exports.deviceSessionCollection)(conn).createIndex({ sessionUid: 1 }, { name: 'sessionUid', unique: true, background: true });
    yield (0, exports.deviceSessionCollection)(conn).createIndex({ deviceIdentityHash: 1 }, { name: 'deviceIdentityHash', background: true });
    yield (0, exports.deviceSessionCollection)(conn).createIndex({ createdAt: 1 }, { name: 'createdAt', background: true, expireAfterSeconds: THIRTY_DAYS_IN_SECS });
});
exports.prepareDeviceSessionTable = prepareDeviceSessionTable;
const createDeviceSessionModel = (conn) => ({
    fetchByUid(sessionUid) {
        return (0, exports.deviceSessionCollection)(conn).findOne({ sessionUid }, { session: conn.session });
    },
    fetchByDeviceIdentityHash(deviceIdentityHash) {
        return (0, exports.deviceSessionCollection)(conn).findOne({ deviceIdentityHash }, { session: conn.session });
    },
    create({ sessionUid, deviceIdentityHash, createdAt, }) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.deviceSessionCollection)(conn).insertOne({ sessionUid, deviceIdentityHash, createdAt }, { session: conn.session });
        });
    },
    remove(session) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, exports.deviceSessionCollection)(conn).deleteOne({ sessionUid: session.sessionUid }, { session: conn.session });
        });
    },
});
exports.createDeviceSessionModel = createDeviceSessionModel;
//# sourceMappingURL=deviceSessionModel.js.map