"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceReportFileModel = exports.prepareDeviceReportFileTable = void 0;
const generator_1 = require("@signageos/lib/dist/Hash/generator");
const collections_1 = require("../../Lib/collections");
const deviceReportFileCollection = (conn) => conn.connection.collection(collections_1.DeviceCollection.ReportFile);
const prepareDeviceReportFileTable = (conn) => __awaiter(void 0, void 0, void 0, function* () {
    yield deviceReportFileCollection(conn).createIndex({ uid: 1 }, { name: 'uid', unique: true, background: true });
    yield deviceReportFileCollection(conn).createIndex({ deviceIdentityHash: 1 }, { name: 'deviceIdentityHash', background: true });
    yield deviceReportFileCollection(conn).createIndex({ createdAt: 1 }, { name: 'createdAt', background: true });
    yield deviceReportFileCollection(conn).createIndex({ deviceIdentityHash: 1, createdAt: 1 }, { name: 'deviceIdentityHash_createdAt', background: true });
});
exports.prepareDeviceReportFileTable = prepareDeviceReportFileTable;
const createDeviceReportFileModel = (conn) => ({
    fetchListByPropertyFilter(propertyFilter, limit) {
        const filter = {};
        if (typeof propertyFilter.deviceIdentityHash !== 'undefined') {
            filter.deviceIdentityHash = propertyFilter.deviceIdentityHash;
        }
        if (typeof propertyFilter.createdSince !== 'undefined') {
            filter.createdAt = Object.assign(Object.assign({}, (filter.createdAt || {})), { $gte: propertyFilter.createdSince });
        }
        if (typeof propertyFilter.createdUntil !== 'undefined') {
            filter.createdAt = Object.assign(Object.assign({}, (filter.createdAt || {})), { $lt: propertyFilter.createdUntil });
        }
        let query = deviceReportFileCollection(conn).find(filter);
        if (typeof limit !== 'undefined') {
            query = query.limit(limit);
        }
        query = query.sort({ createdAt: 1 });
        return query.toArray();
    },
    fetchByUid(uid) {
        return deviceReportFileCollection(conn).findOne({ uid });
    },
    fetchListByDevice(deviceRow) {
        const query = deviceReportFileCollection(conn).find({
            deviceIdentityHash: deviceRow.identityHash,
        });
        return query.sort({ createdAt: 1 }).toArray();
    },
    create(deviceRow, urn, createdAt) {
        return __awaiter(this, void 0, void 0, function* () {
            const newRow = {
                uid: (0, generator_1.generateUniqueHash)(),
                deviceIdentityHash: deviceRow.identityHash,
                urn,
                createdAt,
            };
            yield deviceReportFileCollection(conn).insertOne(newRow);
        });
    },
    deleteCreatedUntil(createdUntil) {
        return __awaiter(this, void 0, void 0, function* () {
            yield deviceReportFileCollection(conn).deleteMany({
                createdAt: {
                    $lt: createdUntil,
                },
            });
        });
    },
});
exports.createDeviceReportFileModel = createDeviceReportFileModel;
//# sourceMappingURL=deviceReportFileModel.js.map